/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.util;

import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;

public class IDMUtil {
    public static boolean isGroupType(Class<? extends IdentityType> identityType) {
        return Group.class.isAssignableFrom(identityType);
    }

    public static boolean isRoleType(Class<? extends IdentityType> identityType) {
        return Role.class.isAssignableFrom(identityType);
    }

    public static boolean isUserType(Class<? extends IdentityType> identityType) {
        return User.class.isAssignableFrom(identityType);
    }

    public static boolean isAgentType(Class<? extends IdentityType> identityType) {
        return Agent.class.isAssignableFrom(identityType);
    }

    public static FeatureSet.FeatureGroup getFeatureGroup(IdentityType identityType) {
        if (User.class.isInstance(identityType)) {
            return FeatureSet.FeatureGroup.user;
        }
        if (Agent.class.isInstance(identityType)) {
            return FeatureSet.FeatureGroup.agent;
        }
        if (Group.class.isInstance(identityType)) {
            return FeatureSet.FeatureGroup.group;
        }
        if (Role.class.isInstance(identityType)) {
            return FeatureSet.FeatureGroup.role;
        }
        throw IDMMessages.MESSAGES.identityTypeUnsupportedType(identityType.getClass());
    }

    public static QueryParameter[] getDefaultParamsForSorting(Class<? extends IdentityType> clazz) {
        if (IDMUtil.isAgentType(clazz)) {
            return new QueryParameter[]{Agent.LOGIN_NAME};
        }
        if (IDMUtil.isGroupType(clazz)) {
            return new QueryParameter[]{Group.NAME};
        }
        if (IDMUtil.isRoleType(clazz)) {
            return new QueryParameter[]{Role.NAME};
        }
        return new QueryParameter[]{IdentityType.ID};
    }

    public static boolean arraysEqual(String[] arr1, String[] arr2) {
        if (arr1 != null && arr2 == null) {
            return false;
        }
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null && arr2 != null) {
            return false;
        }
        int length1 = arr1.length;
        int length2 = arr2.length;
        if (length1 != length2) {
            return false;
        }
        boolean foundMatch = false;
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                if (!arr1[i].equals(arr2[j])) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                return false;
            }
            foundMatch = false;
        }
        return true;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

