/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.SecurityContext;

public class GroupHandler
extends IdentityTypeHandler<Group> {
    public GroupHandler() {
        this.getSortParametersMapping().put(Group.NAME, PropertyType.IDENTITY_NAME);
    }

    @Override
    protected void doPopulateIdentityInstance(SecurityContext context, Object toIdentity, Group fromGroup, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.IDENTITY_PARTITION, store.lookupPartitionObject(context, context.getPartition()), true);
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.IDENTITY_NAME, (Object)fromGroup.getName(), true);
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.GROUP_PATH, (Object)fromGroup.getPath(), true);
        if (fromGroup.getParentGroup() != null) {
            Object parentIdentity = store.lookupIdentityObjectById(context, fromGroup.getParentGroup().getId());
            if (parentIdentity == null) {
                parentIdentity = store.lookupIdentityObjectById(context, fromGroup.getParentGroup().getId());
            }
            jpaConfig.setModelPropertyValue(toIdentity, PropertyType.GROUP_PARENT, parentIdentity, true);
        }
    }

    @Override
    void remove(SecurityContext context, Object identity, Group identityType, JPAIdentityStore store) {
        this.disassociateChildren(context, identityType, store);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Group fromIdentityType) {
        return new GroupCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Group fromIdentityType) {
        return new GroupUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Group fromIdentityType) {
        return new GroupDeletedEvent(fromIdentityType);
    }

    private void disassociateChildren(SecurityContext context, Group group, JPAIdentityStore store) {
        EntityManager em = store.getEntityManager(context);
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(jpaConfig.getIdentityClass());
        Root root = criteria.from(jpaConfig.getIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(jpaConfig.getModelProperty(PropertyType.GROUP_PARENT).getName());
        predicates.add(builder.equal((Expression)join.get(jpaConfig.getModelProperty(PropertyType.IDENTITY_NAME).getName()), (Object)group.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List resultList = em.createQuery(criteria).getResultList();
        for (Object object : resultList) {
            jpaConfig.getModelProperty(PropertyType.GROUP_PARENT).setValue(object, null);
            em.merge(object);
        }
    }

    @Override
    protected Group doCreateIdentityType(SecurityContext context, Object identity, JPAIdentityStore store) {
        SimpleGroup group = null;
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        Object parentInstance = jpaConfig.getModelPropertyValue(Object.class, identity, PropertyType.GROUP_PARENT);
        String name = (String)jpaConfig.getModelPropertyValue(String.class, identity, PropertyType.IDENTITY_NAME);
        if (parentInstance != null) {
            String groupPath = (String)jpaConfig.getModelPropertyValue(String.class, parentInstance, PropertyType.GROUP_PATH);
            group = new SimpleGroup(name, store.getGroup(context, groupPath));
        } else {
            group = new SimpleGroup(name);
        }
        return group;
    }

    @Override
    public List<Predicate> getPredicate(SecurityContext context, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(context, criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(Group.NAME);
        if (parameterValues != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.IDENTITY_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(Group.PATH)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.GROUP_PATH).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(Group.PARENT)) != null) {
            Join join = criteria.getRoot().join(jpaConfig.getModelProperty(PropertyType.GROUP_PARENT).getName());
            predicates.add(builder.equal((Expression)join.get(jpaConfig.getModelProperty(PropertyType.IDENTITY_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(Group.HAS_MEMBER)) != null) {
            for (Object object : parameterValues) {
                if (Agent.class.isInstance(object)) {
                    DefaultRelationshipQuery<GroupMembership> query = new DefaultRelationshipQuery<GroupMembership>(context, GroupMembership.class, store);
                    query.setParameter((QueryParameter)GroupMembership.MEMBER, object);
                    List<GroupMembership> resultList = query.getResultList();
                    if (!resultList.isEmpty()) {
                        ArrayList<String> relIds = new ArrayList<String>();
                        for (GroupMembership memberships : resultList) {
                            relIds.add(memberships.getId());
                        }
                        Subquery subquery = criteria.getCriteria().subquery(jpaConfig.getRelationshipIdentityClass());
                        Root fromProject = subquery.from(jpaConfig.getRelationshipIdentityClass());
                        subquery.select((Expression)fromProject.get(jpaConfig.getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID).getName()));
                        Join join = fromProject.join(jpaConfig.getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
                        ArrayList<Object> subqueryPredicates = new ArrayList<Object>();
                        subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(jpaConfig.getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).getName()), (Object)GroupMembership.GROUP.getName()));
                        subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(jpaConfig.getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID).getName()), (Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.IDENTITY_ID).getName())));
                        subqueryPredicates.add(criteria.getBuilder().in((Expression)join.get(jpaConfig.getModelProperty(PropertyType.RELATIONSHIP_ID).getName())).value(relIds));
                        subquery.where(subqueryPredicates.toArray(new Predicate[subqueryPredicates.size()]));
                        predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
                        continue;
                    }
                    predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
                    continue;
                }
                if (Group.class.isInstance(object)) {
                    Group childGroup = (Group)object;
                    if (childGroup != null && childGroup.getParentGroup() != null) {
                        Object childObject = store.lookupIdentityObjectById(context, childGroup.getId());
                        List<Object> parents = this.getParentGroups(criteria, store, builder, childObject);
                        predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value(parents));
                        continue;
                    }
                    predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
                    continue;
                }
                throw IDMMessages.MESSAGES.queryUnsupportedParameterValue("Group.HAS_MEMBER", object);
            }
        }
        return predicates;
    }

    private List<Object> getParentGroups(JPACriteriaQueryBuilder criteria, JPAIdentityStore store, CriteriaBuilder builder, Object childGroup) {
        ArrayList<Object> parents = new ArrayList<Object>();
        Object parent = store.getConfig().getModelProperty(PropertyType.GROUP_PARENT).getValue(childGroup);
        if (parent != null) {
            parents.add(parent);
            parents.addAll(this.getParentGroups(criteria, store, builder, parent));
        }
        return parents;
    }
}

