/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.IdentityTypeHandlerFactory;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.SecurityContext;

public class JPACriteriaQueryBuilder {
    private IdentityQuery<?> identityQuery;
    private CriteriaBuilder builder;
    private Root<?> root;
    private CriteriaQuery<?> criteria;
    private JPAIdentityStore identityStore;

    public JPACriteriaQueryBuilder(SecurityContext context, JPAIdentityStore identityStore, IdentityQuery<?> identityQuery) {
        this.identityStore = identityStore;
        this.identityQuery = identityQuery;
        this.builder = this.getEntityManager(context).getCriteriaBuilder();
        this.criteria = this.builder.createQuery(this.getConfig().getIdentityClass());
        this.root = this.criteria.from(this.getConfig().getIdentityClass());
    }

    public List<Predicate> getPredicates(SecurityContext context) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!IdentityType.class.equals((Object)this.getIdentityQuery().getIdentityType())) {
            String discriminator = this.getConfig().getIdentityTypeDiscriminator(this.identityQuery.getIdentityType());
            predicates.add(this.builder.equal((Expression)this.root.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_DISCRIMINATOR).getName()), (Object)discriminator));
            IdentityTypeHandler<IdentityType> identityTypeManager = IdentityTypeHandlerFactory.getHandler(this.identityQuery.getIdentityType());
            predicates.addAll(identityTypeManager.getPredicate(context, this, this.identityStore));
        } else {
            DefaultIdentityTypeHandler identityTypeManager = new DefaultIdentityTypeHandler();
            predicates.addAll(identityTypeManager.getPredicate(context, this, this.identityStore));
        }
        return predicates;
    }

    public List<Order> getOrders() {
        DefaultIdentityTypeHandler identityTypeManager = !IdentityType.class.equals((Object)this.getIdentityQuery().getIdentityType()) ? IdentityTypeHandlerFactory.getHandler(this.identityQuery.getIdentityType()) : new DefaultIdentityTypeHandler();
        return identityTypeManager.getOrders(this, this.identityStore);
    }

    protected CriteriaQuery<?> getCriteria() {
        return this.criteria;
    }

    protected CriteriaBuilder getBuilder() {
        return this.builder;
    }

    protected Root<?> getRoot() {
        return this.root;
    }

    protected IdentityQuery<?> getIdentityQuery() {
        return this.identityQuery;
    }

    private JPAIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    private EntityManager getEntityManager(SecurityContext context) {
        return this.identityStore.getEntityManager(context);
    }

    private class DefaultIdentityTypeHandler
    extends IdentityTypeHandler<IdentityType> {
        private DefaultIdentityTypeHandler() {
        }

        @Override
        protected IdentityType doCreateIdentityType(SecurityContext context, Object identity, JPAIdentityStore store) {
            return null;
        }

        @Override
        protected void doPopulateIdentityInstance(SecurityContext context, Object toIdentity, IdentityType fromIdentityType, JPAIdentityStore store) {
        }

        @Override
        protected AbstractBaseEvent raiseCreatedEvent(IdentityType fromIdentityType) {
            return null;
        }

        @Override
        protected AbstractBaseEvent raiseUpdatedEvent(IdentityType fromIdentityType) {
            return null;
        }

        @Override
        protected AbstractBaseEvent raiseDeletedEvent(IdentityType fromIdentityType) {
            return null;
        }
    }
}

