/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.SecurityContext;

public class UserHandler
extends IdentityTypeHandler<User> {
    public UserHandler() {
        this.getSortParametersMapping().put(User.LOGIN_NAME, PropertyType.AGENT_LOGIN_NAME);
        this.getSortParametersMapping().put(User.FIRST_NAME, PropertyType.USER_FIRST_NAME);
        this.getSortParametersMapping().put(User.LAST_NAME, PropertyType.USER_LAST_NAME);
        this.getSortParametersMapping().put(User.EMAIL, PropertyType.USER_EMAIL);
    }

    @Override
    protected void doPopulateIdentityInstance(SecurityContext context, Object toIdentity, User fromUser, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.IDENTITY_PARTITION, store.lookupPartitionObject(context, context.getPartition()), true);
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.IDENTITY_ID, (Object)fromUser.getId(), true);
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.AGENT_LOGIN_NAME, (Object)fromUser.getLoginName(), true);
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.USER_FIRST_NAME, (Object)fromUser.getFirstName());
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.USER_LAST_NAME, (Object)fromUser.getLastName());
        jpaConfig.setModelPropertyValue(toIdentity, PropertyType.USER_EMAIL, (Object)fromUser.getEmail());
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(User fromIdentityType) {
        return new UserCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(User fromIdentityType) {
        return new UserUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(User fromIdentityType) {
        return new UserDeletedEvent(fromIdentityType);
    }

    @Override
    public List<Predicate> getPredicate(SecurityContext context, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(context, criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(User.LOGIN_NAME);
        if (parameterValues != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.AGENT_LOGIN_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(User.FIRST_NAME)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.USER_FIRST_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(User.LAST_NAME)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.USER_LAST_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(User.EMAIL)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(jpaConfig.getModelProperty(PropertyType.USER_EMAIL).getName()), parameterValues[0]));
        }
        return predicates;
    }

    @Override
    protected User doCreateIdentityType(SecurityContext context, Object identity, JPAIdentityStore store) {
        JPAIdentityStoreConfiguration jpaConfig = store.getConfig();
        String loginName = jpaConfig.getModelProperty(PropertyType.AGENT_LOGIN_NAME).getValue(identity).toString();
        SimpleUser user = new SimpleUser(loginName);
        user.setFirstName((String)jpaConfig.getModelPropertyValue(String.class, identity, PropertyType.USER_FIRST_NAME));
        user.setLastName((String)jpaConfig.getModelPropertyValue(String.class, identity, PropertyType.USER_LAST_NAME));
        user.setEmail((String)jpaConfig.getModelPropertyValue(String.class, identity, PropertyType.USER_EMAIL));
        return user;
    }
}

