/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

public abstract class LDAPEntry
implements Serializable {
    private static final long serialVersionUID = -6220260371962877017L;
    private Attributes attributes = new BasicAttributes(true);
    private String dnSuffix;

    public LDAPEntry() {
    }

    public LDAPEntry(String dnSuffix) {
        this.dnSuffix = dnSuffix;
    }

    public String getDN() {
        try {
            return this.getDN(this.getLDAPAttributes().get(this.getAttributeForBinding()).get().toString());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBidingName() {
        try {
            return this.getAttributeForBinding() + "=" + this.getLDAPAttributes().get(this.getAttributeForBinding()).get().toString();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAttributeForBinding() {
        return "cn";
    }

    public String getDN(String name) {
        return this.getAttributeForBinding() + "=" + name + "," + this.dnSuffix;
    }

    public String getDnSuffix() {
        return this.dnSuffix;
    }

    public void setDnSuffix(String dnSuffix) {
        this.dnSuffix = dnSuffix;
    }

    public void addMember(LDAPEntry childEntry) {
        Attribute memberAttribute = this.getLDAPAttributes().get("member");
        if (memberAttribute != null) {
            if (memberAttribute.contains(" ")) {
                memberAttribute.remove(" ");
            }
        } else {
            memberAttribute = new BasicAttribute("member");
        }
        memberAttribute.add(childEntry.getDN());
        this.getLDAPAttributes().put(memberAttribute);
    }

    public void removeMember(LDAPEntry childEntry) {
        Attribute memberAttribute = this.getLDAPAttributes().get("member");
        if (memberAttribute != null) {
            memberAttribute.remove(childEntry.getDN());
            if (memberAttribute.size() == 0) {
                memberAttribute.add(" ");
            }
        }
    }

    protected Attributes getLDAPAttributes() {
        return this.attributes;
    }

    protected void setLDAPAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean isMember(LDAPEntry member) {
        Attribute memberAttribute = this.getLDAPAttributes().get("member");
        return memberAttribute != null && memberAttribute.contains(member.getDN());
    }
}

