/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;

public class AbstractIdentityManagerTestCase {
    private IdentityManager identityManager;

    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    public void setIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    protected User loadOrCreateUser(String userName, boolean alwaysCreate) {
        User user = this.getIdentityManager().getUser(userName);
        if (user != null && alwaysCreate) {
            this.getIdentityManager().remove((IdentityType)user);
            user = null;
        }
        if (user == null) {
            user = new SimpleUser(userName);
            this.getIdentityManager().add((IdentityType)user);
        }
        return this.getIdentityManager().getUser(userName);
    }

    protected Agent loadOrCreateAgent(String id, boolean alwaysCreate) {
        Agent agent = this.getIdentityManager().getAgent(id);
        if (agent != null && alwaysCreate) {
            this.getIdentityManager().remove((IdentityType)agent);
            agent = null;
        }
        if (agent == null) {
            agent = new SimpleAgent(id);
            this.getIdentityManager().add((IdentityType)agent);
        }
        return this.getIdentityManager().getAgent(id);
    }

    protected Role loadOrCreateRole(String name, boolean alwaysCreate) {
        Role role = this.getIdentityManager().getRole(name);
        if (role != null && alwaysCreate) {
            this.getIdentityManager().remove((IdentityType)role);
            role = null;
        }
        if (role == null) {
            role = new SimpleRole(name);
            this.getIdentityManager().add((IdentityType)role);
        }
        return this.getIdentityManager().getRole(name);
    }

    protected Group loadOrCreateGroup(String name, String parentGroupName, boolean alwaysCreate) {
        Group group;
        Group parentGroup = this.getIdentityManager().getGroup(parentGroupName);
        if (parentGroup != null && parentGroupName != null && alwaysCreate) {
            this.getIdentityManager().remove((IdentityType)parentGroup);
            parentGroup = null;
        }
        if (parentGroup == null && parentGroupName != null) {
            parentGroup = new SimpleGroup(parentGroupName);
            this.getIdentityManager().add((IdentityType)parentGroup);
        }
        if ((group = this.getIdentityManager().getGroup(name)) != null && alwaysCreate) {
            this.getIdentityManager().remove((IdentityType)group);
            group = null;
        }
        if (group == null) {
            group = parentGroupName == null ? new SimpleGroup(name) : new SimpleGroup(name, parentGroup);
            this.getIdentityManager().add((IdentityType)group);
        }
        return this.getIdentityManager().getGroup(name);
    }
}

