/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public abstract class AbstractIdentityTypeTestCase<T extends IdentityType>
extends AbstractIdentityManagerTestCase {
    @Test
    public void testDisable() throws Exception {
        T enabledIdentityTypeInstance = this.getIdentityType(true);
        junit.framework.Assert.assertTrue((boolean)enabledIdentityTypeInstance.isEnabled());
        enabledIdentityTypeInstance.setEnabled(false);
        this.updateIdentityType(enabledIdentityTypeInstance);
        T disabledIdentityTypeInstance = this.getIdentityType(false);
        junit.framework.Assert.assertFalse((boolean)disabledIdentityTypeInstance.isEnabled());
        disabledIdentityTypeInstance.setEnabled(true);
        this.updateIdentityType(disabledIdentityTypeInstance);
        enabledIdentityTypeInstance = this.getIdentityType(false);
        junit.framework.Assert.assertTrue((boolean)enabledIdentityTypeInstance.isEnabled());
    }

    protected abstract void updateIdentityType(T var1);

    protected abstract T getIdentityType(boolean var1);

    @Test
    public void testExpiration() throws Exception {
        T validIdentityTypeInstance = this.getIdentityType(true);
        Date expirationDate = new Date();
        validIdentityTypeInstance.setExpirationDate(expirationDate);
        this.updateIdentityType(validIdentityTypeInstance);
        T expiredIdentityTypeInstance = this.getIdentityType(false);
        Thread.sleep(500L);
        Assert.assertNotNull((Object)expiredIdentityTypeInstance.getExpirationDate());
        junit.framework.Assert.assertTrue((boolean)new Date().after(expiredIdentityTypeInstance.getExpirationDate()));
        junit.framework.Assert.assertTrue((expirationDate.compareTo(expiredIdentityTypeInstance.getExpirationDate()) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetOneValuedAttribute() throws Exception {
        T storedIdentityTypeInstance = this.getIdentityType(true);
        storedIdentityTypeInstance.setAttribute(new Attribute("one-valued", (Serializable)((Object)"1")));
        this.updateIdentityType(storedIdentityTypeInstance);
        T updatedIdentityTypeInstance = this.getIdentityType(false);
        Attribute oneValuedAttribute = updatedIdentityTypeInstance.getAttribute("one-valued");
        Assert.assertNotNull((Object)oneValuedAttribute);
        junit.framework.Assert.assertEquals((String)"1", (String)((String)((Object)oneValuedAttribute.getValue())));
    }

    @Test
    public void testSetMultiValuedAttribute() throws Exception {
        T storedIdentityTypeInstance = this.getIdentityType(true);
        storedIdentityTypeInstance.setAttribute(new Attribute("multi-valued", (Serializable)new String[]{"1", "2", "3"}));
        this.updateIdentityType(storedIdentityTypeInstance);
        T updatedIdentityTypeInstance = this.getIdentityType(false);
        Attribute multiValuedAttribute = updatedIdentityTypeInstance.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        Assert.assertNotNull((Object)multiValuedAttribute.getValue());
        junit.framework.Assert.assertEquals((int)3, (int)((String[])multiValuedAttribute.getValue()).length);
    }

    @Test
    public void testSetMultipleAttributes() throws Exception {
        T storedIdentityTypeInstance = this.getIdentityType(true);
        storedIdentityTypeInstance.setAttribute(new Attribute("QuestionTotal", (Serializable)((Object)"2")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question1", (Serializable)((Object)"What is favorite toy?")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question1Answer", (Serializable)((Object)"Gum")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question2", (Serializable)((Object)"What is favorite word?")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question2Answer", (Serializable)((Object)"Hi")));
        this.updateIdentityType(storedIdentityTypeInstance);
        T updatedIdentityTypeInstance = this.getIdentityType(false);
        junit.framework.Assert.assertEquals((String)"2", (String)((String)((Object)updatedIdentityTypeInstance.getAttribute("QuestionTotal").getValue())));
        junit.framework.Assert.assertEquals((String)"What is favorite toy?", (String)((String)((Object)updatedIdentityTypeInstance.getAttribute("Question1").getValue())));
        junit.framework.Assert.assertEquals((String)"Gum", (String)((String)((Object)updatedIdentityTypeInstance.getAttribute("Question1Answer").getValue())));
        junit.framework.Assert.assertEquals((Object)"What is favorite word?", (Object)updatedIdentityTypeInstance.getAttribute("Question2").getValue());
        junit.framework.Assert.assertEquals((String)"Hi", (String)((String)((Object)updatedIdentityTypeInstance.getAttribute("Question2Answer").getValue())));
    }

    @Test
    public void testGetAllAttributes() throws Exception {
        T storedIdentityTypeInstance = this.getIdentityType(true);
        storedIdentityTypeInstance.setAttribute(new Attribute("QuestionTotal", (Serializable)((Object)"2")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question1", (Serializable)((Object)"What is favorite toy?")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question1Answer", (Serializable)((Object)"Gum")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question2", (Serializable)((Object)"What is favorite word?")));
        storedIdentityTypeInstance.setAttribute(new Attribute("Question2Answer", (Serializable)((Object)"Hi")));
        this.updateIdentityType(storedIdentityTypeInstance);
        T updatedIdentityTypeInstance = this.getIdentityType(false);
        Collection allAttributes = updatedIdentityTypeInstance.getAttributes();
        junit.framework.Assert.assertFalse((boolean)allAttributes.isEmpty());
        boolean hasQuestionTotal = false;
        boolean hasQuestion1 = false;
        boolean hasQuestion1Answer = false;
        boolean hasQuestion2 = false;
        boolean hasQuestion2Answer = false;
        for (Attribute attribute : allAttributes) {
            if (attribute.getName().equals("QuestionTotal")) {
                hasQuestionTotal = true;
            }
            if (attribute.getName().equals("Question1")) {
                hasQuestion1 = true;
            }
            if (attribute.getName().equals("Question1Answer")) {
                hasQuestion1Answer = true;
            }
            if (attribute.getName().equals("Question2")) {
                hasQuestion2 = true;
            }
            if (!attribute.getName().equals("Question2Answer")) continue;
            hasQuestion2Answer = true;
        }
        junit.framework.Assert.assertTrue((boolean)hasQuestionTotal);
        junit.framework.Assert.assertTrue((boolean)hasQuestion1);
        junit.framework.Assert.assertTrue((boolean)hasQuestion1Answer);
        junit.framework.Assert.assertTrue((boolean)hasQuestion2);
        junit.framework.Assert.assertTrue((boolean)hasQuestion2Answer);
    }

    @Test
    public void testUpdateAttribute() throws Exception {
        T storedIdentityTypeInstance = this.getIdentityType(true);
        storedIdentityTypeInstance.setAttribute(new Attribute("multi-valued", (Serializable)new String[]{"1", "2", "3"}));
        this.updateIdentityType(storedIdentityTypeInstance);
        T updatedIdentityTypeInstance = this.getIdentityType(false);
        Attribute multiValuedAttribute = updatedIdentityTypeInstance.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        multiValuedAttribute.setValue((Serializable)new String[]{"3", "4", "5"});
        updatedIdentityTypeInstance.setAttribute(multiValuedAttribute);
        this.updateIdentityType(updatedIdentityTypeInstance);
        updatedIdentityTypeInstance = this.getIdentityType(false);
        multiValuedAttribute = updatedIdentityTypeInstance.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        junit.framework.Assert.assertEquals((int)3, (int)((String[])multiValuedAttribute.getValue()).length);
        Object[] values = (String[])multiValuedAttribute.getValue();
        Arrays.sort(values);
        junit.framework.Assert.assertTrue((boolean)Arrays.equals(values, new String[]{"3", "4", "5"}));
    }

    @Test
    public void testRemoveAttribute() throws Exception {
        T storedIdentityTypeInstance = this.getIdentityType(true);
        storedIdentityTypeInstance.setAttribute(new Attribute("multi-valued", (Serializable)new String[]{"1", "2", "3"}));
        this.updateIdentityType(storedIdentityTypeInstance);
        T updatedIdentityTypeInstance = this.getIdentityType(false);
        Attribute multiValuedAttribute = updatedIdentityTypeInstance.getAttribute("multi-valued");
        Assert.assertNotNull((Object)multiValuedAttribute);
        updatedIdentityTypeInstance.removeAttribute("multi-valued");
        this.updateIdentityType(updatedIdentityTypeInstance);
        updatedIdentityTypeInstance = this.getIdentityType(false);
        multiValuedAttribute = updatedIdentityTypeInstance.getAttribute("multi-valued");
        junit.framework.Assert.assertNull((Object)multiValuedAttribute);
    }
}

