/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentGroupsRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testAddAgentToGroup() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someAgent, someGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someGroup));
        Group someAnotherGroup = this.loadOrCreateGroup("someAnotherGroup", null, true);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
        identityManager.addToGroup((IdentityType)someAgent, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
    }

    @Test
    public void testRemoveAgentFromGroup() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        Group someAnotherGroup = this.loadOrCreateGroup("someAnotherGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)someAgent, someGroup);
        identityManager.addToGroup((IdentityType)someAgent, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
        identityManager.removeFromGroup((IdentityType)someAgent, someGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someAgent, someGroup));
        identityManager.removeFromGroup((IdentityType)someAgent, someAnotherGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someAgent, someAnotherGroup));
    }

    @Test
    public void testFindAgentGroups() throws Exception {
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        Group someAnotherGroup = this.loadOrCreateGroup("someAnotherGroup", null, true);
        Group someImportantGroup = this.loadOrCreateGroup("someImportantGroup", null, true);
        Agent user = this.loadOrCreateAgent("someAgent", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        identityManager.removeFromGroup((IdentityType)user, someAnotherGroup);
        identityManager.removeFromGroup((IdentityType)user, someImportantGroup);
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someAnotherGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((IdentityType)user, someImportantGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantGroup"));
    }

    private boolean contains(List<Group> result, String roleId) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

