/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class AgentManagementTestCase
extends AbstractIdentityTypeTestCase<Agent> {
    @Test
    public void testCreate() throws Exception {
        Agent newAgent = this.loadOrCreateAgent("someAgent", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)newAgent);
        Agent storedAgent = identityManager.getAgent(newAgent.getId());
        Assert.assertNotNull((Object)storedAgent);
        junit.framework.Assert.assertEquals((String)newAgent.getId(), (String)storedAgent.getId());
        junit.framework.Assert.assertTrue((boolean)storedAgent.isEnabled());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedAgent.getCreatedDate()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGet() throws Exception {
        Agent storedAgent = this.getIdentityType(true);
        IdentityManager identityManager = this.getIdentityManager();
        storedAgent = identityManager.getAgent(storedAgent.getId());
        Assert.assertNotNull((Object)storedAgent);
        junit.framework.Assert.assertEquals((String)"someAgent", (String)storedAgent.getId());
    }

    @Test
    public void testUpdate() throws Exception {
        Agent storedAgent = this.getIdentityType(true);
        Assert.assertNotNull((Object)storedAgent);
        junit.framework.Assert.assertEquals((String)"someAgent", (String)storedAgent.getId());
        IdentityManager identityManager = this.getIdentityManager();
        storedAgent.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"1")));
        identityManager.update((IdentityType)storedAgent);
        Agent updatedUser = identityManager.getAgent(storedAgent.getId());
        Assert.assertNotNull((Object)updatedUser.getAttribute("someAttribute"));
        junit.framework.Assert.assertEquals((Object)"1", (Object)updatedUser.getAttribute("someAttribute").getValue());
    }

    @Test
    public void testRemove() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Agent someAgent = this.getIdentityType(true);
        Agent anotherAgent = this.loadOrCreateAgent("someAnotherUser", true);
        Assert.assertNotNull((Object)someAgent);
        Assert.assertNotNull((Object)anotherAgent);
        identityManager.remove((IdentityType)someAgent);
        Agent removedUserInstance = this.getIdentityManager().getAgent(someAgent.getId());
        junit.framework.Assert.assertNull((Object)removedUserInstance);
        anotherAgent = identityManager.getAgent(anotherAgent.getId());
        Assert.assertNotNull((Object)anotherAgent);
    }

    @Override
    protected void updateIdentityType(Agent identityTypeInstance) {
        this.getIdentityManager().update((IdentityType)identityTypeInstance);
    }

    @Override
    protected Agent getIdentityType(boolean alwaysCreate) {
        Agent user = this.loadOrCreateAgent("someAgent", alwaysCreate);
        this.getIdentityManager().update((IdentityType)user);
        return user;
    }
}

