/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindById() throws Exception {
        this.loadOrCreateAgent("someAgent", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ID, new Object[]{"someAgent"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"someAgent", (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleGroupRole() throws Exception {
        Agent user = this.loadOrCreateAgent("someAgent", true);
        Group salesGroup = this.loadOrCreateGroup("Sales", null, true);
        Role managerRole = this.loadOrCreateRole("Manager", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_GROUP_ROLE, (Object[])new GroupRole[]{new SimpleGroupRole((IdentityType)user, managerRole, salesGroup)});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantGroupRole((IdentityType)user, managerRole, salesGroup);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_GROUP_ROLE, (Object[])new GroupRole[]{new SimpleGroupRole((IdentityType)user, managerRole, salesGroup)});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleGroup() throws Exception {
        Agent user = this.loadOrCreateAgent("admin", true);
        Group administratorGroup = this.loadOrCreateGroup("Administrators", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{"Administrators"});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{"Administrators"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleRole() throws Exception {
        Agent user = this.loadOrCreateAgent("admin", true);
        Role administratorRole = this.loadOrCreateRole("Administrators", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{"Administrators"});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantRole((IdentityType)user, administratorRole);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{"Administrators"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleGroups() throws Exception {
        Agent user = this.loadOrCreateAgent("admin", true);
        Group administratorGroup = this.loadOrCreateGroup("Administrators", null, true);
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        identityManager.addToGroup((IdentityType)user, someGroup);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{administratorGroup.getName(), someGroup.getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{administratorGroup.getName()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleRoles() throws Exception {
        Agent user = this.loadOrCreateAgent("admin", true);
        Role administratorRole = this.loadOrCreateRole("Administrators", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)user, administratorRole);
        identityManager.grantRole((IdentityType)user, someRole);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{administratorRole.getName(), someRole.getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
        identityManager.revokeRole((IdentityType)user, someRole);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{administratorRole.getName()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)user.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleAgentWithGroups() throws Exception {
        Agent adminAgent = this.loadOrCreateAgent("admin", true);
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Group administratorGroup = this.loadOrCreateGroup("Administrators", null, true);
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)adminAgent, administratorGroup);
        identityManager.addToGroup((IdentityType)someAgent, administratorGroup);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{administratorGroup.getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, adminAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        identityManager.addToGroup((IdentityType)adminAgent, someGroup);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.MEMBER_OF, (Object[])new String[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, adminAgent.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
    }

    @Test
    public void testFindByMultipleAgentWithRoles() throws Exception {
        Agent adminAgent = this.loadOrCreateAgent("admin", true);
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Role administratorRole = this.loadOrCreateRole("Administrators", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)adminAgent, administratorRole);
        identityManager.grantRole((IdentityType)someAgent, administratorRole);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{administratorRole.getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, adminAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        identityManager.grantRole((IdentityType)adminAgent, someRole);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.HAS_ROLE, (Object[])new String[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, adminAgent.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
    }

    @Test
    public void testFindEnabledAndDisabledAgents() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Agent someAnotherAgent = this.loadOrCreateAgent("someAnotherAgent", true);
        someAgent.setEnabled(true);
        someAnotherAgent.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        identityManager.update((IdentityType)someAnotherAgent);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{true});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{false});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherAgent.getId()));
        someAgent.setEnabled(false);
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{false});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherAgent.getId()));
        someAnotherAgent.setEnabled(false);
        identityManager.update((IdentityType)someAnotherAgent);
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ENABLED, new Object[]{true});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherAgent.getId()));
    }

    @Test
    public void testFindCreationDate() throws Exception {
        Agent user = this.loadOrCreateAgent("someAgent", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.CREATED_DATE, new Object[]{user.getCreatedDate()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"someAgent", (String)((Agent)result.get(0)).getId());
        query = identityManager.createQuery(Agent.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(Agent.CREATED_DATE, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        Agent user = this.loadOrCreateAgent("someAgent", true);
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        user = identityManager.getAgent("someAgent");
        user.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.EXPIRY_DATE, new Object[]{user.getExpirationDate()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, user.getId()));
        Assert.assertEquals((String)"someAgent", (String)((Agent)result.get(0)).getId());
        query = identityManager.createQuery(Agent.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(Agent.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Agent someAnotherAgent = this.loadOrCreateAgent("someAnotherAgent", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Agent.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(Agent.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(Agent.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        Agent someFutureAgent = this.loadOrCreateAgent("someFutureAgent", true);
        Agent someAnotherFutureAgent = this.loadOrCreateAgent("someAnotherFutureAgent", true);
        query.setParameter(Agent.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(Agent.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        Agent user = this.loadOrCreateAgent("admin", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        user.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, user.getId()));
        Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ID, new Object[]{"admin"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(Agent.ID, new Object[]{"admin"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, user.getId()));
        Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(Agent.ID, new Object[]{"Bad ID"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Date currentDate = new Date();
        someAgent.setExpirationDate(currentDate);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        Agent someAnotherAgent = this.loadOrCreateAgent("someAnotherAgent", true);
        someAnotherAgent.setExpirationDate(currentDate);
        identityManager.update((IdentityType)someAnotherAgent);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(Agent.EXPIRY_BEFORE, new Object[]{currentDate});
        Agent someFutureAgent = this.loadOrCreateAgent("someFutureAgent", true);
        someFutureAgent.setExpirationDate(new Date());
        identityManager.update((IdentityType)someFutureAgent);
        Agent someAnotherFutureAgent = this.loadOrCreateAgent("someAnotherFutureAgent", true);
        someAnotherFutureAgent.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherFutureAgent);
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        Assert.assertFalse((boolean)this.contains(result, someFutureAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.EXPIRY_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someFutureAgent.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(Agent.EXPIRY_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByAgentDefinedAttributes() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
        someAgent.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
    }

    @Test
    public void testFindByAgentDefinedMultiValuedAttributes() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someAgent);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
        someAgent.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someAgent.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someAgent);
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<Agent> result, String userId) {
        for (Agent resultAgent : result) {
            if (!resultAgent.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }
}

