/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentRolesRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testGrantRoleToAgent() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)someAgent, someRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someAgent, someRole));
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someAgent, someAnotherRole));
        identityManager.grantRole((IdentityType)someAgent, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someAgent, someAnotherRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someAgent, someRole));
    }

    @Test
    public void testRevokeRoleFromAgent() throws Exception {
        Agent someAgent = this.loadOrCreateAgent("someAgent", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)someAgent, someRole);
        identityManager.grantRole((IdentityType)someAgent, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someAgent, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someAgent, someAnotherRole));
        identityManager.revokeRole((IdentityType)someAgent, someRole);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someAgent, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someAgent, someAnotherRole));
        identityManager.revokeRole((IdentityType)someAgent, someAnotherRole);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someAgent, someAnotherRole));
    }

    @Test
    public void testFindAgentRoles() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        Role someImportantRole = this.loadOrCreateRole("someImportantRole", true);
        Agent user = this.loadOrCreateAgent("someAgent", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.revokeRole((IdentityType)user, someRole);
        identityManager.revokeRole((IdentityType)user, someAnotherRole);
        identityManager.revokeRole((IdentityType)user, someImportantRole);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someAnotherRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someImportantRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantRole"));
    }

    private boolean contains(List<Role> result, String roleId) {
        for (Role resultRole : result) {
            if (!resultRole.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

