/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class ApplicationRegistrationTestCase
extends AbstractIdentityManagerTestCase {
    private static final String appName = "Test App";
    private static final String appURL = "http://someurl";
    private static final String appDesc = "This is a nice app";

    @Test
    public void appRegister() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Agent oauthApp = this.loadOrCreateAgent(appName, true);
        oauthApp.setAttribute(new Attribute("appURL", (Serializable)((Object)appURL)));
        oauthApp.setAttribute(new Attribute("appDesc", (Serializable)((Object)appDesc)));
        identityManager.update((IdentityType)oauthApp);
        IdentityQuery query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ID, new Object[]{appName});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)appName, (String)((Agent)result.get(0)).getId());
        query = identityManager.createQuery(Agent.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"appURL"), (Object[])new String[]{appURL});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)appName, (String)((Agent)result.get(0)).getId());
        query = identityManager.createQuery(Agent.class);
        query.setParameter(Agent.ID, new Object[]{"bogus"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void appUnregister() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Agent oauthApp = this.loadOrCreateAgent(appName, true);
        oauthApp = identityManager.getAgent(appName);
        Assert.assertNotNull((Object)oauthApp);
        identityManager.remove((IdentityType)oauthApp);
        oauthApp = identityManager.getAgent(appName);
        Assert.assertNull((Object)oauthApp);
    }
}

