/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleRelationship;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class ApplicationUserRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void authorizeAccess() throws Exception {
        String authorizationCode = "ac";
        String accessToken = "at";
        String refreshToken = "rt";
        IdentityManager identityManager = this.getIdentityManager();
        User robert = this.loadOrCreateUser("robert", true);
        SimpleAgent myOauthApp = new SimpleAgent("My OAuth App");
        identityManager.add((IdentityType)myOauthApp);
        SimpleRelationship authorized = new SimpleRelationship("authorized");
        authorized.setFrom((IdentityType)robert);
        authorized.setTo((IdentityType)myOauthApp);
        authorized.setAttribute(new Attribute("authorizationCode", (Serializable)((Object)authorizationCode)));
        authorized.setAttribute(new Attribute("accessToken", (Serializable)((Object)accessToken)));
        authorized.setAttribute(new Attribute("refreshToken", (Serializable)((Object)refreshToken)));
        identityManager.add((IdentityType)authorized);
        IdentityQuery query = identityManager.createQuery(Relationship.class);
        query.setParameter(Relationship.NAME, new Object[]{authorized.getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        authorized = (Relationship)result.get(0);
        Assert.assertEquals((String)authorized.getName(), (String)((Relationship)result.get(0)).getName());
        Assert.assertNotNull((Object)authorized.to());
        Assert.assertNotNull((Object)authorized.from());
        Assert.assertNotNull((Object)authorized.getAttribute("authorizationCode"));
        query = identityManager.createQuery(Relationship.class);
        query.setParameter(Relationship.TO, new Object[]{myOauthApp});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)authorized.getName(), (String)((Relationship)result.get(0)).getName());
        Assert.assertNotNull((Object)authorized.to());
        Assert.assertNotNull((Object)authorized.from());
        query = identityManager.createQuery(Relationship.class);
        query.setParameter(Relationship.FROM, new Object[]{robert});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)authorized.getName(), (String)((Relationship)result.get(0)).getName());
        Assert.assertNotNull((Object)authorized.to());
        Assert.assertNotNull((Object)authorized.from());
        query = identityManager.createQuery(Relationship.class);
        query.setParameter(Relationship.FROM, new Object[]{myOauthApp});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

