/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class GroupManagementTestCase
extends AbstractIdentityTypeTestCase<Group> {
    @Test
    public void testCreate() throws Exception {
        Group newGroupInstance = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        Group storedGroupInstance = identityManager.getGroup(newGroupInstance.getName());
        Assert.assertNotNull((Object)storedGroupInstance);
        junit.framework.Assert.assertEquals((String)newGroupInstance.getKey(), (String)storedGroupInstance.getKey());
        junit.framework.Assert.assertEquals((String)newGroupInstance.getName(), (String)storedGroupInstance.getName());
    }

    @Test
    public void testCreateWithParentGroup() throws Exception {
        Group childGroup = this.loadOrCreateGroup("childGroup", "parentGroup", true);
        IdentityManager identityManager = this.getIdentityManager();
        Group storedChildGroup = identityManager.getGroup(childGroup.getName());
        Assert.assertNotNull((Object)storedChildGroup);
        Assert.assertNotNull((Object)storedChildGroup.getParentGroup());
        junit.framework.Assert.assertEquals((String)childGroup.getKey(), (String)storedChildGroup.getKey());
        junit.framework.Assert.assertEquals((String)childGroup.getName(), (String)storedChildGroup.getName());
        junit.framework.Assert.assertEquals((String)childGroup.getParentGroup().getName(), (String)storedChildGroup.getParentGroup().getName());
    }

    @Test
    public void testGet() throws Exception {
        Group storedGroupInstance = this.getIdentityType(true);
        IdentityManager identityManager = this.getIdentityManager();
        storedGroupInstance = identityManager.getGroup(storedGroupInstance.getName());
        Assert.assertNotNull((Object)storedGroupInstance);
        Assert.assertNotNull((Object)storedGroupInstance.getParentGroup());
        junit.framework.Assert.assertEquals((String)"GROUP:///Test Parent Group/Test Group", (String)storedGroupInstance.getKey());
        junit.framework.Assert.assertEquals((String)"Test Group", (String)storedGroupInstance.getName());
    }

    @Test
    public void testGetWithParent() throws Exception {
        Group storedGroupInstance = this.getIdentityType(true);
        IdentityManager identityManager = this.getIdentityManager();
        storedGroupInstance = identityManager.getGroup("Test Group", (Group)new SimpleGroup("Test Parent Group"));
        Assert.assertNotNull((Object)storedGroupInstance);
        Assert.assertNotNull((Object)storedGroupInstance.getParentGroup());
        junit.framework.Assert.assertEquals((String)"GROUP:///Test Parent Group/Test Group", (String)storedGroupInstance.getKey());
        junit.framework.Assert.assertEquals((String)"Test Group", (String)storedGroupInstance.getName());
        Group invalidGroupInstance = identityManager.getGroup("Test Group", (Group)new SimpleGroup("Invalid Parent Group"));
        junit.framework.Assert.assertNull((Object)invalidGroupInstance);
    }

    @Test
    public void testRemove() throws Exception {
        Group storedGroupInstance = this.getIdentityType(true);
        Assert.assertNotNull((Object)storedGroupInstance);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.remove((IdentityType)storedGroupInstance);
        Group removedGroupInstance = identityManager.getGroup(storedGroupInstance.getName());
        junit.framework.Assert.assertNull((Object)removedGroupInstance);
    }

    @Override
    protected void updateIdentityType(Group identityTypeInstance) {
        this.getIdentityManager().update((IdentityType)identityTypeInstance);
    }

    @Override
    protected Group getIdentityType(boolean alwaysCreate) {
        return this.loadOrCreateGroup("Test Group", "Test Parent Group", alwaysCreate);
    }
}

