/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class GroupQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindByName() throws Exception {
        this.loadOrCreateGroup("admin", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{"admin"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"admin", (String)((Group)result.get(0)).getName());
    }

    @Test
    public void testFindEnabledAndDisabledGroups() throws Exception {
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        Group someAnotherGroup = this.loadOrCreateGroup("someAnotherGroup", null, true);
        someGroup.setEnabled(true);
        someAnotherGroup.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        identityManager.update((IdentityType)someAnotherGroup);
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{true});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{false});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        someGroup.setEnabled(false);
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{false});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherGroup.getName()));
        someAnotherGroup.setEnabled(false);
        identityManager.update((IdentityType)someAnotherGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.ENABLED, new Object[]{true});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someGroup.getName()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherGroup.getName()));
    }

    @Test
    public void testFindWithParent() throws Exception {
        Group group = this.loadOrCreateGroup("someGroup", "Parent Group", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.PARENT, new Object[]{group.getParentGroup().getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)group.getName(), (String)((Group)result.get(0)).getName());
        Assert.assertEquals((String)group.getParentGroup().getName(), (String)((Group)result.get(0)).getParentGroup().getName());
    }

    @Test
    public void testFindCreationDate() throws Exception {
        Group group = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.CREATED_DATE, new Object[]{group.getCreatedDate()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"someGroup", (String)((Group)result.get(0)).getName());
        query = identityManager.createQuery(Group.class);
        Thread.sleep(500L);
        query.setParameter(Group.CREATED_DATE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        Group group = this.loadOrCreateGroup("someGroup", null, true);
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        group = identityManager.getGroup("someGroup");
        group.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)group);
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.EXPIRY_DATE, new Object[]{expirationDate});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, group.getName()));
        Assert.assertEquals((String)"someGroup", (String)((Group)result.get(0)).getName());
        query = identityManager.createQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(Group.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        Group someAnotherGroup = this.loadOrCreateGroup("someAnotherGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(Group.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(Group.CREATED_BEFORE, new Object[]{new Date()});
        Thread.sleep(500L);
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        query = identityManager.createQuery(Group.class);
        Group someFutureGroup = this.loadOrCreateGroup("someFutureGroup", null, true);
        Group someAnotherFutureGroup = this.loadOrCreateGroup("someAnotherFutureGroup", null, true);
        query.setParameter(Group.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createQuery(Group.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        Group group = this.loadOrCreateGroup("admin", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)group);
        group.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)group);
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, group.getName()));
        Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        someGroup.setExpirationDate(new Date());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        Group someAnotherGroup = this.loadOrCreateGroup("someAnotherGroup", null, true);
        someAnotherGroup.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherGroup);
        IdentityQuery query = identityManager.createQuery(Group.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(Group.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(Group.EXPIRY_BEFORE, new Object[]{new Date()});
        Thread.sleep(1000L);
        Group someFutureGroup = this.loadOrCreateGroup("someFutureGroup", null, true);
        someFutureGroup.setExpirationDate(new Date());
        identityManager.update((IdentityType)someFutureGroup);
        Group someAnotherFutureGroup = this.loadOrCreateGroup("someAnotherFutureGroup", null, true);
        someAnotherFutureGroup.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherFutureGroup);
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createQuery(Group.class);
        query.setParameter(Group.EXPIRY_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureGroup.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureGroup.getName()));
        query = identityManager.createQuery(Group.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.EXPIRY_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByGroupDefinedAttributes() throws Exception {
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someGroup.getName()));
        someGroup.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
    }

    @Test
    public void testFindByGroupDefinedMultiValuedAttributes() throws Exception {
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someGroup);
        IdentityQuery query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someGroup.getName()));
        someGroup.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someGroup.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someGroup);
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getName()));
        query = identityManager.createQuery(Group.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<Group> result, String groupName) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(groupName)) continue;
            return true;
        }
        return false;
    }
}

