/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class PasswordCredentialTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testSuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.loadOrCreateUser("someUser", true);
        Password plainTextPassword = new Password("updated_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword, new Date(), null);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(user.getId());
        credential.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testUnsuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.loadOrCreateUser("someUser", true);
        Password plainTextPassword = new Password("updated_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword, new Date(), null);
        UsernamePasswordCredentials badUserName = new UsernamePasswordCredentials();
        badUserName.setUsername("Bad" + user.getId());
        badUserName.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)badUserName);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badUserName.getStatus());
        UsernamePasswordCredentials badPassword = new UsernamePasswordCredentials();
        plainTextPassword = new Password("bad_password".toCharArray());
        badPassword.setUsername(user.getId());
        badPassword.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)badPassword);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badPassword.getStatus());
    }

    @Test
    public void testExpiration() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.loadOrCreateUser("someUser", true);
        Password plainTextPassword = new Password("updated_password".toCharArray());
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, -1);
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword, new Date(), expirationDate.getTime());
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(user.getId());
        credential.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.EXPIRED, (Object)credential.getStatus());
        Password newPassword = new Password("new_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)newPassword);
        credential = new UsernamePasswordCredentials(user.getId(), newPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testUpdatePassword() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.loadOrCreateUser("someUser", true);
        Password firstPassword = new Password("password1".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)firstPassword);
        UsernamePasswordCredentials firstCredential = new UsernamePasswordCredentials(user.getId(), firstPassword);
        identityManager.validateCredentials((Credentials)firstCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)firstCredential.getStatus());
        Password secondPassword = new Password("password2".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)secondPassword);
        UsernamePasswordCredentials secondCredential = new UsernamePasswordCredentials(user.getId(), secondPassword);
        identityManager.validateCredentials((Credentials)secondCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)secondCredential.getStatus());
        identityManager.validateCredentials((Credentials)firstCredential);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)firstCredential.getStatus());
    }
}

