/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class RoleManagementTestCase
extends AbstractIdentityTypeTestCase<Role> {
    @Test
    public void testCreate() throws Exception {
        Role newRoleInstance = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        Role storedRoleInstance = identityManager.getRole(newRoleInstance.getName());
        Assert.assertNotNull((Object)storedRoleInstance);
        junit.framework.Assert.assertEquals((String)newRoleInstance.getKey(), (String)storedRoleInstance.getKey());
        junit.framework.Assert.assertEquals((String)newRoleInstance.getName(), (String)storedRoleInstance.getName());
    }

    @Test
    public void testGet() throws Exception {
        Role storedRoleInstance = this.getIdentityType(true);
        Assert.assertNotNull((Object)storedRoleInstance);
        IdentityManager identityManager = this.getIdentityManager();
        storedRoleInstance = identityManager.getRole(storedRoleInstance.getName());
        Assert.assertNotNull((Object)storedRoleInstance);
        junit.framework.Assert.assertEquals((String)"ROLE://Administrator", (String)storedRoleInstance.getKey());
        junit.framework.Assert.assertEquals((String)"Administrator", (String)storedRoleInstance.getName());
    }

    @Test
    public void testRemove() throws Exception {
        Role storedRoleInstance = this.getIdentityType(true);
        Assert.assertNotNull((Object)storedRoleInstance);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.remove((IdentityType)storedRoleInstance);
        Role removedRoleInstance = identityManager.getRole(storedRoleInstance.getName());
        junit.framework.Assert.assertNull((Object)removedRoleInstance);
    }

    @Override
    protected void updateIdentityType(Role identityTypeInstance) {
        this.getIdentityManager().update((IdentityType)identityTypeInstance);
    }

    @Override
    protected Role getIdentityType(boolean alwaysCreate) {
        return this.loadOrCreateRole("Administrator", alwaysCreate);
    }
}

