/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class RoleQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindByName() throws Exception {
        this.loadOrCreateRole("admin", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"admin", (String)((Role)result.get(0)).getName());
    }

    @Test
    public void testFindEnabledAndDisabledRoles() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        someRole.setEnabled(true);
        someAnotherRole.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        identityManager.update((IdentityType)someAnotherRole);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{true});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{false});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        someRole.setEnabled(false);
        identityManager.update((IdentityType)someRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{false});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherRole.getName()));
        someAnotherRole.setEnabled(false);
        identityManager.update((IdentityType)someAnotherRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ENABLED, new Object[]{true});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someRole.getName()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherRole.getName()));
    }

    @Test
    public void testFindCreationDate() throws Exception {
        Role role = this.loadOrCreateRole("someRole", false);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.CREATED_DATE, new Object[]{role.getCreatedDate()});
        Thread.sleep(500L);
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"someRole", (String)((Role)result.get(0)).getName());
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.CREATED_DATE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        Role role = this.loadOrCreateRole("someRole", true);
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        role = identityManager.getRole("someRole");
        role.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)role);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.EXPIRY_DATE, new Object[]{role.getExpirationDate()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, role.getName()));
        Assert.assertEquals((String)"someRole", (String)((Role)result.get(0)).getName());
        query = identityManager.createQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(Role.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(Role.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(Role.CREATED_BEFORE, new Object[]{new Date()});
        Thread.sleep(500L);
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        query = identityManager.createQuery(Role.class);
        Role someFutureRole = this.loadOrCreateRole("someFutureRole", true);
        Role someAnotherFutureRole = this.loadOrCreateRole("someAnotherFutureRole", true);
        query.setParameter(Role.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createQuery(Role.class);
        Thread.sleep(1000L);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        Role role = this.loadOrCreateRole("admin", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)role);
        role.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)role);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, role.getName()));
        Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        someRole.setExpirationDate(new Date());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        someAnotherRole.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherRole);
        IdentityQuery query = identityManager.createQuery(Role.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(Role.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(Role.EXPIRY_BEFORE, new Object[]{new Date()});
        Thread.sleep(1000L);
        Role someFutureRole = this.loadOrCreateRole("someFutureRole", true);
        someFutureRole.setExpirationDate(new Date());
        identityManager.update((IdentityType)someFutureRole);
        Role someAnotherFutureRole = this.loadOrCreateRole("someAnotherFutureRole", true);
        someAnotherFutureRole.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherFutureRole);
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.EXPIRY_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someFutureRole.getName()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherFutureRole.getName()));
        query = identityManager.createQuery(Role.class);
        Calendar futureExpiryDate = Calendar.getInstance();
        futureExpiryDate.add(12, 1);
        query.setParameter(Role.EXPIRY_AFTER, new Object[]{futureExpiryDate.getTime()});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByRoleDefinedAttributes() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someRole.getName()));
        someRole.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
    }

    @Test
    public void testFindByRoleDefinedMultiValuedAttributes() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someRole);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someRole.getName()));
        someRole.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someRole.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getName()));
        query = identityManager.createQuery(Role.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<Role> result, String roleId) {
        for (Role resultRole : result) {
            if (!resultRole.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

