/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityTypeTestCase;

public class UserManagementTestCase
extends AbstractIdentityTypeTestCase<User> {
    @Test
    public void testCreate() throws Exception {
        User newUserInstance = this.loadOrCreateUser("jduke", true);
        newUserInstance.setEmail("jduke@jboss.org");
        newUserInstance.setFirstName("Java");
        newUserInstance.setLastName("Duke");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)newUserInstance);
        User storedUserInstance = identityManager.getUser(newUserInstance.getId());
        Assert.assertNotNull((Object)storedUserInstance);
        junit.framework.Assert.assertEquals((String)newUserInstance.getId(), (String)storedUserInstance.getId());
        junit.framework.Assert.assertEquals((String)newUserInstance.getFirstName(), (String)storedUserInstance.getFirstName());
        junit.framework.Assert.assertEquals((String)newUserInstance.getLastName(), (String)storedUserInstance.getLastName());
        junit.framework.Assert.assertEquals((String)newUserInstance.getEmail(), (String)storedUserInstance.getEmail());
        junit.framework.Assert.assertTrue((boolean)storedUserInstance.isEnabled());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedUserInstance.getCreatedDate()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGet() throws Exception {
        User storedUserInstance = this.getIdentityType(true);
        IdentityManager identityManager = this.getIdentityManager();
        storedUserInstance = identityManager.getUser(storedUserInstance.getId());
        Assert.assertNotNull((Object)storedUserInstance);
        junit.framework.Assert.assertEquals((String)"admin", (String)storedUserInstance.getId());
        junit.framework.Assert.assertEquals((String)"The", (String)storedUserInstance.getFirstName());
        junit.framework.Assert.assertEquals((String)"Administrator", (String)storedUserInstance.getLastName());
        junit.framework.Assert.assertEquals((String)"admin@jboss.org", (String)storedUserInstance.getEmail());
    }

    @Test
    public void testUpdate() throws Exception {
        User storedUserInstance = this.getIdentityType(true);
        Assert.assertNotNull((Object)storedUserInstance);
        junit.framework.Assert.assertEquals((String)"admin", (String)storedUserInstance.getId());
        junit.framework.Assert.assertEquals((String)"The", (String)storedUserInstance.getFirstName());
        junit.framework.Assert.assertEquals((String)"Administrator", (String)storedUserInstance.getLastName());
        junit.framework.Assert.assertEquals((String)"admin@jboss.org", (String)storedUserInstance.getEmail());
        storedUserInstance.setFirstName("Updated " + storedUserInstance.getFirstName());
        storedUserInstance.setLastName("Updated " + storedUserInstance.getLastName());
        storedUserInstance.setEmail("Updated " + storedUserInstance.getEmail());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)storedUserInstance);
        User updatedUser = identityManager.getUser(storedUserInstance.getId());
        junit.framework.Assert.assertEquals((String)"Updated The", (String)updatedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)"Updated Administrator", (String)updatedUser.getLastName());
        junit.framework.Assert.assertEquals((String)"Updated admin@jboss.org", (String)updatedUser.getEmail());
    }

    @Test
    public void testRemove() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User someUser = this.getIdentityType(true);
        User anotherUser = this.loadOrCreateUser("someAnotherUser", true);
        Assert.assertNotNull((Object)someUser);
        Assert.assertNotNull((Object)anotherUser);
        identityManager.remove((IdentityType)someUser);
        User removedUserInstance = this.getIdentityManager().getUser(someUser.getId());
        junit.framework.Assert.assertNull((Object)removedUserInstance);
        anotherUser = identityManager.getUser(anotherUser.getId());
        Assert.assertNotNull((Object)anotherUser);
    }

    @Override
    protected void updateIdentityType(User identityTypeInstance) {
        this.getIdentityManager().update((IdentityType)identityTypeInstance);
    }

    @Override
    protected User getIdentityType(boolean alwaysCreate) {
        User user = this.loadOrCreateUser("admin", alwaysCreate);
        user.setEmail("admin@jboss.org");
        user.setFirstName("The");
        user.setLastName("Administrator");
        this.getIdentityManager().update((IdentityType)user);
        return user;
    }
}

