/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class UserQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindById() throws Exception {
        this.loadOrCreateUser("admin", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.ID, new Object[]{"admin"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"admin", (String)((User)result.get(0)).getId());
    }

    @Test
    public void testFindByFirstNameAndLastName() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        user.setFirstName("The");
        user.setLastName("Administrator");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        Assert.assertNotNull((Object)user);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter(User.LAST_NAME, new Object[]{"Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        query.setParameter(User.LAST_NAME, new Object[]{"Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"admin", (String)((User)result.get(0)).getId());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        query.setParameter(User.LAST_NAME, new Object[]{"Bad Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByEmail() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        user.setEmail("admin@jboss.org");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"admin", (String)((User)result.get(0)).getId());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"badadmin@jboss.org"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBySingleGroupRole() throws Exception {
        User user = this.loadOrCreateUser("someUser", true);
        Group salesGroup = this.loadOrCreateGroup("Sales", null, true);
        Role managerRole = this.loadOrCreateRole("Manager", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_GROUP_ROLE, (Object[])new GroupRole[]{new SimpleGroupRole((IdentityType)user, managerRole, salesGroup)});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantGroupRole((IdentityType)user, managerRole, salesGroup);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_GROUP_ROLE, (Object[])new GroupRole[]{new SimpleGroupRole((IdentityType)user, managerRole, salesGroup)});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleGroup() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        Group administratorGroup = this.loadOrCreateGroup("Administrators", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{"Administrators"});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{"Administrators"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleRole() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        Role administratorRole = this.loadOrCreateRole("Administrators", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{"Administrators"});
        List result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantRole((IdentityType)user, administratorRole);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{"Administrators"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleGroups() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        Group administratorGroup = this.loadOrCreateGroup("Administrators", null, true);
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)user, administratorGroup);
        identityManager.addToGroup((IdentityType)user, someGroup);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{administratorGroup.getName(), someGroup.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
        identityManager.removeFromGroup((IdentityType)user, someGroup);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{administratorGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleRoles() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        Role administratorRole = this.loadOrCreateRole("Administrators", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)user, administratorRole);
        identityManager.grantRole((IdentityType)user, someRole);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{administratorRole.getName(), someRole.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
        identityManager.revokeRole((IdentityType)user, someRole);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{administratorRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)user.getId(), (String)((User)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleUserWithGroups() throws Exception {
        User adminUser = this.loadOrCreateUser("admin", true);
        User someUser = this.loadOrCreateUser("someUser", true);
        Group administratorGroup = this.loadOrCreateGroup("Administrators", null, true);
        Group someGroup = this.loadOrCreateGroup("someGroup", null, true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((IdentityType)adminUser, administratorGroup);
        identityManager.addToGroup((IdentityType)someUser, administratorGroup);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{administratorGroup.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        identityManager.addToGroup((IdentityType)adminUser, someGroup);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.MEMBER_OF, (Object[])new String[]{administratorGroup.getName(), someGroup.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getId()));
    }

    @Test
    public void testFindByMultipleUserWithRoles() throws Exception {
        User adminUser = this.loadOrCreateUser("admin", true);
        User someUser = this.loadOrCreateUser("someUser", true);
        Role administratorRole = this.loadOrCreateRole("Administrators", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)adminUser, administratorRole);
        identityManager.grantRole((IdentityType)someUser, administratorRole);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{administratorRole.getName()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        identityManager.grantRole((IdentityType)adminUser, someRole);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{administratorRole.getName(), someRole.getName()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, adminUser.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getId()));
    }

    @Test
    public void testFindEnabledAndDisabledUsers() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        User someAnotherUser = this.loadOrCreateUser("someAnotherUser", true);
        someUser.setEnabled(true);
        someAnotherUser.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        identityManager.update((IdentityType)someAnotherUser);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{true});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someUser.setEnabled(false);
        identityManager.update((IdentityType)someUser);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someAnotherUser.getId()));
        someAnotherUser.setEnabled(false);
        identityManager.update((IdentityType)someAnotherUser);
        query = identityManager.createQuery(User.class);
        query.setParameter(User.ENABLED, new Object[]{true});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someAnotherUser.getId()));
    }

    @Test
    public void testFindCreationDate() throws Exception {
        User user = this.loadOrCreateUser("someUser", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.CREATED_DATE, new Object[]{user.getCreatedDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"someUser", (String)((User)result.get(0)).getId());
        query = identityManager.createQuery(User.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_DATE, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindExpiryDate() throws Exception {
        User user = this.loadOrCreateUser("someUser", true);
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        user = identityManager.getUser("someUser");
        user.setExpirationDate(expirationDate);
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.EXPIRY_DATE, new Object[]{user.getExpirationDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getId()));
        junit.framework.Assert.assertEquals((String)"someUser", (String)((User)result.get(0)).getId());
        query = identityManager.createQuery(User.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 1);
        query.setParameter(User.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        User someAnotherUser = this.loadOrCreateUser("someAnotherUser", true);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createQuery(User.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(User.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(User.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        query = identityManager.createQuery(User.class);
        User someFutureUser = this.loadOrCreateUser("someFutureUser", true);
        User someAnotherFutureUser = this.loadOrCreateUser("someAnotherFutureUser", true);
        query.setParameter(User.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter(User.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getId()));
        query = identityManager.createQuery(User.class);
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(User.CREATED_AFTER, new Object[]{futureDate.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindUsingMultipleParameters() throws Exception {
        User user = this.loadOrCreateUser("admin", true);
        user.setEmail("admin@jboss.org");
        user.setFirstName("The");
        user.setLastName("Administrator");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)user);
        user.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update((IdentityType)user);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getId()));
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, user.getId()));
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        query = identityManager.createQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(User.FIRST_NAME, new Object[]{"Bad First Name"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenExpirationDate() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        someUser.setExpirationDate(new Date());
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        User someAnotherUser = this.loadOrCreateUser("someAnotherUser", true);
        someAnotherUser.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherUser);
        IdentityQuery query = identityManager.createQuery(User.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(User.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(User.EXPIRY_BEFORE, new Object[]{new Date()});
        Thread.sleep(1000L);
        User someFutureUser = this.loadOrCreateUser("someFutureUser", true);
        someFutureUser.setExpirationDate(new Date());
        identityManager.update((IdentityType)someFutureUser);
        User someAnotherFutureUser = this.loadOrCreateUser("someAnotherFutureUser", true);
        someAnotherFutureUser.setExpirationDate(new Date());
        identityManager.update((IdentityType)someAnotherFutureUser);
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter(User.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter(User.EXPIRY_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureUser.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureUser.getId()));
        query = identityManager.createQuery(User.class);
        Thread.sleep(500L);
        query.setParameter(User.EXPIRY_AFTER, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByUserDefinedAttributes() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update((IdentityType)someUser);
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getId()));
        someUser.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update((IdentityType)someUser);
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
    }

    @Test
    public void testFindByUserDefinedMultiValuedAttributes() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)someUser);
        IdentityQuery query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someUser.getId()));
        someUser.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        someUser.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update((IdentityType)someUser);
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someUser.getId()));
        query = identityManager.createQuery(User.class);
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)IdentityType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    private boolean contains(List<User> result, String userId) {
        for (User resultUser : result) {
            if (!resultUser.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }
}

