/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class UserRolesRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testGrantRoleToUser() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)someUser, someRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        identityManager.grantRole((IdentityType)someUser, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
    }

    @Test
    public void testRevokeRoleFromUser() throws Exception {
        User someUser = this.loadOrCreateUser("someUser", true);
        Role someRole = this.loadOrCreateRole("someRole", true);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)someUser, someRole);
        identityManager.grantRole((IdentityType)someUser, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        identityManager.revokeRole((IdentityType)someUser, someRole);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someUser, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
        identityManager.revokeRole((IdentityType)someUser, someAnotherRole);
        Assert.assertFalse((boolean)identityManager.hasRole((IdentityType)someUser, someAnotherRole));
    }

    @Test
    public void testFindUserRoles() throws Exception {
        Role someRole = this.loadOrCreateRole("someRole", true);
        Role someAnotherRole = this.loadOrCreateRole("someAnotherRole", true);
        Role someImportantRole = this.loadOrCreateRole("someImportantRole", true);
        User user = this.loadOrCreateUser("someUser", true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.revokeRole((IdentityType)user, someRole);
        identityManager.revokeRole((IdentityType)user, someAnotherRole);
        identityManager.revokeRole((IdentityType)user, someImportantRole);
        IdentityQuery query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someAnotherRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole((IdentityType)user, someImportantRole);
        query = identityManager.createQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantRole"));
    }

    private boolean contains(List<Role> result, String roleId) {
        for (Role resultRole : result) {
            if (!resultRole.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

