/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.suites;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.StoreConfiguration;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.DefaultIdentityStoreInvocationContextFactory;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfigurationBuilder;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.test.idm.GroupManagementTestCase;
import org.picketlink.test.idm.GroupQueryTestCase;
import org.picketlink.test.idm.RoleManagementTestCase;
import org.picketlink.test.idm.RoleQueryTestCase;
import org.picketlink.test.idm.UserGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.UserGroupsRelationshipTestCase;
import org.picketlink.test.idm.UserManagementTestCase;
import org.picketlink.test.idm.UserQueryTestCase;
import org.picketlink.test.idm.UserRolesRelationshipTestCase;
import org.picketlink.test.idm.runners.IdentityManagerRunner;
import org.picketlink.test.idm.runners.TestLifecycle;

@RunWith(value=IdentityManagerRunner.class)
@Suite.SuiteClasses(value={UserManagementTestCase.class, RoleManagementTestCase.class, GroupManagementTestCase.class, UserGroupsRelationshipTestCase.class, UserRolesRelationshipTestCase.class, UserGroupRoleRelationshipTestCase.class, RoleQueryTestCase.class, GroupQueryTestCase.class, UserQueryTestCase.class})
public class LDAPIdentityStoreTestSuite
extends AbstractLDAPTest
implements TestLifecycle {
    private static LDAPIdentityStoreTestSuite instance;
    private static final String LDAP_URL = "ldap://localhost:10389";
    private static final String ROLES_DN_SUFFIX = "ou=Roles,dc=jboss,dc=org";
    private static final String GROUP_DN_SUFFIX = "ou=Groups,dc=jboss,dc=org";
    private static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";

    public static TestLifecycle init() throws Exception {
        if (instance == null) {
            instance = new LDAPIdentityStoreTestSuite();
        }
        return instance;
    }

    @BeforeClass
    public static void onBeforeClass() {
        try {
            LDAPIdentityStoreTestSuite.init();
            instance.setup();
            instance.importLDIF("ldap/users.ldif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onInit() {
    }

    @Override
    public IdentityManager createIdentityManager() {
        IdentityConfiguration config = new IdentityConfiguration();
        config.addStoreConfiguration((StoreConfiguration)LDAPIdentityStoreTestSuite.getConfiguration());
        DefaultIdentityManager identityManager = new DefaultIdentityManager();
        identityManager.bootstrap(config, (IdentityStoreInvocationContextFactory)new DefaultIdentityStoreInvocationContextFactory(null));
        return identityManager;
    }

    @Override
    public void onDestroy() {
    }

    public static LDAPConfiguration getConfiguration() {
        LDAPConfigurationBuilder builder = new LDAPConfigurationBuilder();
        LDAPConfiguration config = (LDAPConfiguration)builder.build();
        config.setBindDN("uid=admin,ou=system").setBindCredential("secret").setLdapURL(LDAP_URL);
        config.setUserDNSuffix(USER_DN_SUFFIX).setRoleDNSuffix(ROLES_DN_SUFFIX);
        config.setGroupDNSuffix(GROUP_DN_SUFFIX);
        return config;
    }

    public void importLDIF(String fileName) throws Exception {
        super.importLDIF(fileName);
    }
}

