/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.schema.internal;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.credential.DigestCredential;
import org.picketlink.idm.credential.DigestCredentialUtil;
import org.picketlink.idm.credential.PasswordCredential;
import org.picketlink.idm.credential.X509CertificateCredential;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.jpa.schema.DatabaseGroup;
import org.picketlink.idm.jpa.schema.DatabaseMembership;
import org.picketlink.idm.jpa.schema.DatabaseRole;
import org.picketlink.idm.jpa.schema.DatabaseUser;
import org.picketlink.idm.jpa.schema.internal.JPACallback;
import org.picketlink.idm.jpa.schema.internal.JPATemplate;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class SimpleJPAIdentityStore
implements IdentityStore {
    private static final String PASSWORD_ATTRIBUTE_NAME = "password";
    private static final String CERTIFICATE_ATTRIBUTE_NAME = "credential";
    private JPATemplate jpaTemplate;

    public void createUser(IdentityStoreInvocationContext ctx, User user) {
        User newUser = null;
        if (!(user instanceof DatabaseUser)) {
            newUser = new DatabaseUser(user.getId());
            newUser.setFirstName(user.getFirstName());
            newUser.setLastName(user.getLastName());
            newUser.setEmail(user.getEmail());
            for (String attribName : user.getAttributes().keySet()) {
                newUser.setAttribute(attribName, user.getAttribute(attribName));
            }
        } else {
            newUser = user;
        }
        this.persist(newUser);
    }

    public void removeUser(IdentityStoreInvocationContext ctx, User user) {
        if (user.getId() == null) {
            throw new IllegalArgumentException("User identifier nor provided.");
        }
        this.remove(user);
    }

    public User getUser(IdentityStoreInvocationContext ctx, String name) {
        return (User)this.findIdentityTypeByKey("id", name, "USER.LOAD_BY_KEY");
    }

    public Group createGroup(IdentityStoreInvocationContext ctx, String name, Group parent) {
        DatabaseGroup newGroup = new DatabaseGroup(name);
        newGroup.setParentGroup((DatabaseGroup)parent);
        this.persist(newGroup);
        return newGroup;
    }

    public void removeGroup(IdentityStoreInvocationContext ctx, Group group) {
        if (group.getId() == null) {
            throw new IllegalArgumentException("Group identifier not provided.");
        }
        this.remove(group);
    }

    public Group getGroup(IdentityStoreInvocationContext ctx, String group) {
        return (Group)this.findIdentityTypeByKey("name", group, "GROUP.LOAD_BY_KEY");
    }

    public Role createRole(IdentityStoreInvocationContext ctx, String name) {
        DatabaseRole newRole = new DatabaseRole(name);
        this.persist(newRole);
        return newRole;
    }

    public void removeRole(IdentityStoreInvocationContext ctx, Role role) {
        if (role.getName() == null) {
            throw new IllegalArgumentException("Role name not provided.");
        }
        this.remove(role);
    }

    public Role getRole(IdentityStoreInvocationContext ctx, String role) {
        return (Role)this.findIdentityTypeByKey("name", role, "ROLE.LOAD_BY_KEY");
    }

    public Membership createMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        if (member instanceof User) {
            DatabaseUser dbUser = (DatabaseUser)this.getUser(ctx, ((User)member).getId());
            DatabaseRole dbRole = (DatabaseRole)this.getRole(ctx, role.getName());
            DatabaseGroup dbGroup = (DatabaseGroup)this.getGroup(ctx, group.getName());
            DatabaseMembership newMembership = new DatabaseMembership(dbUser, dbGroup, dbRole);
            dbUser.getMemberships().add(newMembership);
            this.persist(newMembership);
            return newMembership;
        }
        throw new UnsupportedOperationException("Only members of type User are supported by this implementation.");
    }

    public void removeMembership(IdentityStoreInvocationContext ctx, IdentityType member, Group group, Role role) {
        Membership membership = this.getMembership(ctx, member, group, role);
        if (membership != null) {
            this.remove(membership);
        }
    }

    public Membership getMembership(IdentityStoreInvocationContext ctx, final IdentityType member, final Group group, final Role role) {
        return (Membership)this.executeOperation(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                Query query = entityManager.createNamedQuery("MEMBERSHIP.LOAD_BY_KEY");
                query.setParameter("role", (Object)role);
                query.setParameter("member", (Object)member);
                query.setParameter("group", (Object)group);
                Membership loadedMembership = null;
                try {
                    loadedMembership = (Membership)query.getSingleResult();
                }
                catch (NoResultException nre) {
                    // empty catch block
                }
                return loadedMembership;
            }
        });
    }

    public List<User> executeQuery(IdentityStoreInvocationContext ctx, final UserQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseUser.class);
                Root user = criteriaQuery.from(DatabaseUser.class);
                user.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("id"), (Object)query.getName()));
                }
                if (query.getEmail() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("email"), (Object)query.getEmail()));
                }
                if (query.getFirstName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("firstName"), (Object)query.getFirstName()));
                }
                if (query.getLastName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("lastName"), (Object)query.getLastName()));
                }
                predicates.add(criteriaBuilder.equal((Expression)user.get("enabled"), (Object)query.getEnabled()));
                Join join = null;
                if (query.getRole() != null || query.getRelatedGroup() != null) {
                    join = user.join("memberships");
                }
                if (query.getRole() != null) {
                    Join joinRole = join.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), (Object)query.getRole().getName()));
                }
                if (query.getRelatedGroup() != null) {
                    Join joinGroup = join.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("name"), (Object)query.getRelatedGroup().getName()));
                }
                if (query.getAttributeFilters() != null) {
                    Set entrySet = query.getAttributeFilters().entrySet();
                    for (Map.Entry entry : entrySet) {
                        Join joinAttr = user.join("ownerAttributes");
                        Predicate conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)joinAttr.get("name"), entry.getKey()));
                        conjunction.getExpressions().add(joinAttr.get("value").in((Object[])entry.getValue()));
                        predicates.add(conjunction);
                    }
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public List<Group> executeQuery(IdentityStoreInvocationContext ctx, final GroupQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseGroup.class);
                Root group = criteriaQuery.from(DatabaseGroup.class);
                group.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("name"), (Object)query.getName()));
                }
                if (query.getId() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("id"), (Object)query.getId()));
                }
                if (query.getParentGroup() != null) {
                    Join joinParentGroup = group.join("parentGroup");
                    predicates.add(criteriaBuilder.equal((Expression)joinParentGroup.get("id"), (Object)query.getParentGroup().getId()));
                }
                Join join = null;
                if (query.getRelatedUser() != null || query.getRole() != null) {
                    join = group.join("memberships");
                }
                if (query.getRole() != null) {
                    Join joinRole = join.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), (Object)query.getRole().getName()));
                }
                if (query.getRelatedUser() != null) {
                    Join joinGroup = join.join("member");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), (Object)query.getRelatedUser().getId()));
                }
                if (query.getAttributeFilters() != null) {
                    Set entrySet = query.getAttributeFilters().entrySet();
                    for (Map.Entry entry : entrySet) {
                        Join joinAttr = group.join("ownerAttributes");
                        Predicate conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)joinAttr.get("name"), entry.getKey()));
                        conjunction.getExpressions().add(joinAttr.get("value").in((Object[])entry.getValue()));
                        predicates.add(conjunction);
                    }
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public List<Role> executeQuery(IdentityStoreInvocationContext ctx, final RoleQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseRole.class);
                Root role = criteriaQuery.from(DatabaseRole.class);
                role.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getName() != null) {
                    predicates.add(criteriaBuilder.equal((Expression)role.get("name"), (Object)query.getName()));
                }
                Join join = null;
                if (query.getGroup() != null || query.getOwner() != null) {
                    join = role.join("memberships");
                }
                if (query.getGroup() != null) {
                    Join joinGroup = join.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), (Object)query.getGroup().getId()));
                }
                if (query.getOwner() != null) {
                    Join joinUser = join.join("member");
                    predicates.add(criteriaBuilder.equal((Expression)joinUser.get("key"), (Object)query.getOwner().getKey()));
                }
                if (query.getAttributeFilters() != null) {
                    Set entrySet = query.getAttributeFilters().entrySet();
                    for (Map.Entry entry : entrySet) {
                        Join joinAttr = role.join("ownerAttributes");
                        Predicate conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)joinAttr.get("name"), entry.getKey()));
                        conjunction.getExpressions().add(joinAttr.get("value").in((Object[])entry.getValue()));
                        predicates.add(conjunction);
                    }
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public List<Membership> executeQuery(IdentityStoreInvocationContext ctx, final MembershipQuery query, Range range) {
        return (List)this.jpaTemplate.execute(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseMembership.class);
                Root membership = criteriaQuery.from(DatabaseMembership.class);
                membership.alias("resultClass");
                criteriaQuery.distinct(true);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (query.getGroup() != null) {
                    Join joinGroup = membership.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), (Object)query.getGroup().getId()));
                }
                if (query.getRole() != null) {
                    Join joinRole = membership.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), (Object)query.getRole().getName()));
                }
                if (query.getUser() != null) {
                    Join joinUser = membership.join("member");
                    predicates.add(criteriaBuilder.equal((Expression)joinUser.get("id"), (Object)query.getUser().getId()));
                }
                criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
                TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
                return resultQuery.getResultList();
            }
        });
    }

    public void setAttribute(IdentityStoreInvocationContext ctx, IdentityType identityType, String name, String[] values) {
        if (identityType instanceof User) {
            User user = (User)identityType;
            DatabaseUser databaseUser = (DatabaseUser)this.getUser(ctx, user.getId());
            databaseUser.setAttribute(name, values);
        } else if (identityType instanceof Role) {
            Role role = (Role)identityType;
            DatabaseRole databaseRole = (DatabaseRole)this.getRole(ctx, role.getName());
            databaseRole.setAttribute(name, values);
        } else if (identityType instanceof Group) {
            Group group = (Group)identityType;
            DatabaseGroup databaseGroup = (DatabaseGroup)this.getGroup(ctx, group.getName());
            databaseGroup.setAttribute(name, values);
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
    }

    public void removeAttribute(IdentityStoreInvocationContext ctx, IdentityType identityType, String name) {
        if (identityType instanceof User) {
            User user = (User)identityType;
            DatabaseUser databaseUser = (DatabaseUser)this.getUser(ctx, user.getId());
            if (databaseUser != null) {
                databaseUser.removeAttribute(name);
            }
        } else if (identityType instanceof Role) {
            Role role = (Role)identityType;
            DatabaseRole databaseRole = (DatabaseRole)this.getRole(ctx, role.getName());
            if (databaseRole != null) {
                databaseRole.removeAttribute(name);
            }
        } else if (identityType instanceof Group) {
            Group group = (Group)identityType;
            DatabaseGroup databaseGroup = (DatabaseGroup)this.getGroup(ctx, group.getName());
            if (databaseGroup != null) {
                databaseGroup.removeAttribute(name);
            }
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
    }

    public String[] getAttributeValues(IdentityStoreInvocationContext ctx, IdentityType identityType, String name) {
        if (identityType instanceof DatabaseUser) {
            User user = (User)identityType;
            DatabaseUser databaseUser = (DatabaseUser)this.getUser(ctx, user.getId());
            if (databaseUser != null) {
                return databaseUser.getAttributeValues(name);
            }
        } else if (identityType instanceof Role) {
            Role role = (Role)identityType;
            DatabaseRole databaseRole = (DatabaseRole)this.getRole(ctx, role.getName());
            if (databaseRole != null) {
                return databaseRole.getAttributeValues(name);
            }
        } else if (identityType instanceof Group) {
            Group group = (Group)identityType;
            DatabaseGroup databaseGroup = (DatabaseGroup)this.getGroup(ctx, group.getName());
            if (databaseGroup != null) {
                return databaseGroup.getAttributeValues(name);
            }
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
        return null;
    }

    public Map<String, String[]> getAttributes(IdentityStoreInvocationContext ctx, IdentityType identityType) {
        if (identityType instanceof DatabaseUser) {
            DatabaseUser user = (DatabaseUser)identityType;
            DatabaseUser DatabaseUser2 = (DatabaseUser)this.getUser(ctx, user.getId());
            if (DatabaseUser2 != null) {
                return DatabaseUser2.getAttributes();
            }
        } else if (identityType instanceof DatabaseRole) {
            DatabaseRole role = (DatabaseRole)identityType;
            DatabaseRole databaseRole = (DatabaseRole)this.getRole(ctx, role.getName());
            if (databaseRole != null) {
                return databaseRole.getAttributes();
            }
        } else if (identityType instanceof DatabaseGroup) {
            DatabaseGroup group = (DatabaseGroup)identityType;
            DatabaseGroup databaseGroup = (DatabaseGroup)this.getGroup(ctx, group.getName());
            if (databaseGroup != null) {
                return databaseGroup.getAttributes();
            }
        } else {
            this.throwsNotSupportedIdentityType(identityType);
        }
        return null;
    }

    public void setJpaTemplate(JPATemplate jpaTemplate) {
        this.jpaTemplate = jpaTemplate;
    }

    private Object executeOperation(JPACallback callback) {
        return this.jpaTemplate.execute(callback);
    }

    private void persist(final Object entity) {
        JPACallback callback = new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                entityManager.persist(entity);
                return null;
            }
        };
        this.executeOperation(callback);
    }

    private void remove(final Object entity) {
        this.executeOperation(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                entityManager.remove(entity);
                return null;
            }
        });
    }

    private IdentityType findIdentityTypeByKey(final String idFieldName, final String idValue, final String namedQueryName) {
        return (IdentityType)this.executeOperation(new JPACallback(){

            @Override
            public Object execute(EntityManager entityManager) {
                Query query = entityManager.createNamedQuery(namedQueryName);
                query.setParameter(idFieldName, (Object)idValue);
                Object loadedUser = null;
                try {
                    loadedUser = query.getSingleResult();
                }
                catch (NoResultException nre) {
                }
                catch (NonUniqueResultException nure) {
                    // empty catch block
                }
                return loadedUser;
            }
        });
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, User user, Credential credential) {
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            String providedPassword = passwordCredential.getPassword();
            String expectedPassword = user.getAttribute(PASSWORD_ATTRIBUTE_NAME);
            return expectedPassword != null && providedPassword != null && providedPassword.equals(expectedPassword);
        }
        if (credential instanceof DigestCredential) {
            DigestCredential digestCredential = (DigestCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            String storedPassword = storedUser.getAttribute(PASSWORD_ATTRIBUTE_NAME);
            return DigestCredentialUtil.matchCredential((DigestCredential)digestCredential, (char[])storedPassword.toCharArray());
        }
        if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCredential = (X509CertificateCredential)credential;
            User storedUser = this.getUser(ctx, user.getId());
            String storedCert = storedUser.getAttribute(CERTIFICATE_ATTRIBUTE_NAME);
            if (storedCert != null) {
                try {
                    return storedCert.equals(new String(Base64.encodeBytes((byte[])certCredential.getCertificate().getEncoded())));
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.throwsNotSupportedCredentialType(credential);
        }
        return false;
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, User user, Credential credential) {
        User storedUser = this.getUser(ctx, user.getId());
        if (storedUser == null) {
            throw new RuntimeException("User not found: " + user.getId());
        }
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            storedUser.setAttribute(PASSWORD_ATTRIBUTE_NAME, passwordCredential.getPassword());
        } else if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCredential = (X509CertificateCredential)credential;
            try {
                storedUser.setAttribute(CERTIFICATE_ATTRIBUTE_NAME, new String(Base64.encodeBytes((byte[])certCredential.getCertificate().getEncoded())));
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.throwsNotSupportedCredentialType(credential);
        }
    }

    private void throwsNotSupportedCredentialType(Credential credential) throws IllegalArgumentException {
        throw new IllegalArgumentException("Credential type not supported: " + credential.getClass());
    }

    private void throwsNotSupportedIdentityType(IdentityType identityType) throws IllegalArgumentException {
        throw new IllegalArgumentException("IdentityType not supported: " + identityType.getClass());
    }

    public Set<IdentityStore.Feature> getFeatureSet() {
        return null;
    }
}

