/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.filters.SecurityActions;
import org.picketlink.identity.federation.web.interfaces.IRoleValidator;
import org.picketlink.identity.federation.web.roles.DefaultRoleValidator;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SPFilter
implements Filter {
    private static Logger log = Logger.getLogger(SPFilter.class);
    private final boolean trace = log.isTraceEnabled();
    protected SPType spConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    protected String configFile = "/WEB-INF/picketlink.xml";
    protected String serviceURL = null;
    protected String identityURL = null;
    private TrustKeyManager keyManager;
    private ServletContext context = null;
    private transient SAML2HandlerChain chain = null;
    protected boolean ignoreSignatures = false;
    private IRoleValidator roleValidator = new DefaultRoleValidator();
    private String logOutPage = "/logout.jsp";
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean logOutRequest;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean postMethod = "POST".equalsIgnoreCase(request.getMethod());
        HttpSession session = request.getSession();
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        String gloStr = request.getParameter("GLO");
        boolean bl = logOutRequest = StringUtil.isNotNull(gloStr) && "true".equalsIgnoreCase(gloStr);
        if (!postMethod && !logOutRequest) {
            if (userPrincipal != null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (userPrincipal == null) {
                String relayState = null;
                try {
                    AuthnRequestType authnRequest = this.createSAMLRequest(this.serviceURL, this.identityURL);
                    this.sendRequestToIDP(authnRequest, relayState, response);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
        } else {
            if (!StringUtil.isNotNull(samlRequest) && !StringUtil.isNotNull(samlResponse)) {
                Set<SAML2Handler> handlers = this.chain.handlers();
                IssuerInfoHolder holder = new IssuerInfoHolder(this.serviceURL);
                HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, holder.getIssuer(), null, SAML2Handler.HANDLER_TYPE.SP);
                DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                saml2HandlerResponse.setDestination(this.identityURL);
                try {
                    for (SAML2Handler handler : handlers) {
                        handler.reset();
                        if (saml2HandlerResponse.isInError()) {
                            response.sendError(saml2HandlerResponse.getErrorCode());
                            break;
                        }
                        if (logOutRequest) {
                            saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT);
                        } else {
                            saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH);
                        }
                        handler.generateSAMLRequest(saml2HandlerRequest, saml2HandlerResponse);
                    }
                }
                catch (ProcessingException pe) {
                    throw new RuntimeException(pe);
                }
                Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
                String relayState = saml2HandlerResponse.getRelayState();
                String destination = saml2HandlerResponse.getDestination();
                if (destination != null && samlResponseDocument != null) {
                    try {
                        this.sendToDestination(samlResponseDocument, relayState, destination, response, saml2HandlerResponse.getSendRequest());
                    }
                    catch (Exception e) {
                        if (this.trace) {
                            log.trace((Object)"Exception:", (Throwable)e);
                        }
                        throw new ServletException("PL00032: Service Provider :: Server ExceptionServer Error");
                    }
                    return;
                }
            }
            if (StringUtil.isNotNull(samlResponse)) {
                boolean isValid = false;
                try {
                    isValid = this.validate(request);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                if (!isValid) {
                    throw new ServletException("PL00019: Validation check failedValidity check failed");
                }
                byte[] base64DecodedResponse = PostBindingUtil.base64Decode(samlResponse);
                ByteArrayInputStream is = new ByteArrayInputStream(base64DecodedResponse);
                boolean willSendRequest = true;
                try {
                    SAML2Response saml2Response = new SAML2Response();
                    SAML2Object samlObject = saml2Response.getSAML2ObjectFromStream(is);
                    SAMLDocumentHolder documentHolder = saml2Response.getSamlDocumentHolder();
                    if (!this.ignoreSignatures && !this.verifySignature(documentHolder)) {
                        throw new ServletException("PL00009: Invalid Digital Signature:Cannot verify sender");
                    }
                    Set<SAML2Handler> handlers = this.chain.handlers();
                    IssuerInfoHolder holder = new IssuerInfoHolder(this.serviceURL);
                    HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                    DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, holder.getIssuer(), documentHolder, SAML2Handler.HANDLER_TYPE.SP);
                    if (this.keyManager != null) {
                        saml2HandlerRequest.addOption("DECRYPTING_KEY", this.keyManager.getSigningKey());
                    }
                    DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                    for (SAML2Handler handler : handlers) {
                        if (saml2HandlerResponse.isInError()) {
                            response.sendError(saml2HandlerResponse.getErrorCode());
                            break;
                        }
                        if (samlObject instanceof RequestAbstractType) {
                            handler.handleRequestType(saml2HandlerRequest, saml2HandlerResponse);
                            willSendRequest = false;
                            continue;
                        }
                        handler.handleStatusResponseType(saml2HandlerRequest, saml2HandlerResponse);
                    }
                    Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
                    String relayState = saml2HandlerResponse.getRelayState();
                    String destination = saml2HandlerResponse.getDestination();
                    if (destination != null && samlResponseDocument != null) {
                        this.sendToDestination(samlResponseDocument, relayState, destination, response, willSendRequest);
                        return;
                    }
                    try {
                        session.isNew();
                    }
                    catch (IllegalStateException ise) {
                        RequestDispatcher dispatch = this.context.getRequestDispatcher(this.logOutPage);
                        if (dispatch == null) {
                            log.error((Object)("Cannot dispatch to the logout page: no request dispatcher:" + this.logOutPage));
                        } else {
                            dispatch.forward((ServletRequest)request, (ServletResponse)response);
                        }
                        return;
                    }
                    filterChain.doFilter((ServletRequest)request, servletResponse);
                }
                catch (Exception e) {
                    log.error((Object)"Server Exception:", (Throwable)e);
                    throw new ServletException("PL00032: Service Provider :: Server Exception");
                }
            }
            if (StringUtil.isNotNull(samlRequest)) {
                byte[] base64DecodedRequest = PostBindingUtil.base64Decode(samlRequest);
                ByteArrayInputStream is = new ByteArrayInputStream(base64DecodedRequest);
                boolean willSendRequest = false;
                try {
                    SAML2Request saml2Request = new SAML2Request();
                    SAML2Object samlObject = saml2Request.getSAML2ObjectFromStream(is);
                    SAMLDocumentHolder documentHolder = saml2Request.getSamlDocumentHolder();
                    if (!this.ignoreSignatures && !this.verifySignature(documentHolder)) {
                        throw new ServletException("PL00009: Invalid Digital Signature:Cannot verify sender");
                    }
                    Set<SAML2Handler> handlers = this.chain.handlers();
                    IssuerInfoHolder holder = new IssuerInfoHolder(this.serviceURL);
                    HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                    DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, holder.getIssuer(), documentHolder, SAML2Handler.HANDLER_TYPE.SP);
                    if (this.keyManager != null) {
                        saml2HandlerRequest.addOption("DECRYPTING_KEY", this.keyManager.getSigningKey());
                    }
                    DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                    for (SAML2Handler handler : handlers) {
                        if (saml2HandlerResponse.isInError()) {
                            response.sendError(saml2HandlerResponse.getErrorCode());
                            break;
                        }
                        if (samlObject instanceof RequestAbstractType) {
                            handler.handleRequestType(saml2HandlerRequest, saml2HandlerResponse);
                            willSendRequest = false;
                            continue;
                        }
                        handler.handleStatusResponseType(saml2HandlerRequest, saml2HandlerResponse);
                    }
                    Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
                    String relayState = saml2HandlerResponse.getRelayState();
                    String destination = saml2HandlerResponse.getDestination();
                    if (destination != null && samlResponseDocument != null) {
                        this.sendToDestination(samlResponseDocument, relayState, destination, response, willSendRequest);
                        return;
                    }
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)"Server Exception:", (Throwable)e);
                    }
                    throw new ServletException("PL00032: Service Provider :: Server ExceptionServer Exception");
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String gloPage;
        this.context = filterConfig.getServletContext();
        InputStream is = this.context.getResourceAsStream(this.configFile);
        if (is != null) {
            try {
                this.picketLinkConfiguration = ConfigurationUtil.getConfiguration(is);
                this.spConfiguration = (SPType)this.picketLinkConfiguration.getIdpOrSP();
            }
            catch (ParsingException e) {
                throw new RuntimeException(e);
            }
        }
        is = this.context.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
        if (is == null) {
            throw new RuntimeException("PL00025: Service Provider:: Configuration File missing:" + this.configFile + " missing");
        }
        try {
            this.spConfiguration = ConfigurationUtil.getSPConfiguration(is);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        try {
            this.identityURL = this.spConfiguration.getIdentityURL();
            this.serviceURL = this.spConfiguration.getServiceURL();
            this.canonicalizationMethod = this.spConfiguration.getCanonicalizationMethod();
            log.info((Object)("SPFilter:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + this.canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType(this.canonicalizationMethod);
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String roleValidatorName = filterConfig.getInitParameter("ROLE_VALIDATOR");
        if (roleValidatorName != null && !"".equals(roleValidatorName)) {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), roleValidatorName);
                this.roleValidator = (IRoleValidator)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, String> options = new HashMap<String, String>();
        String roles = filterConfig.getInitParameter("ROLES");
        if (this.trace) {
            log.trace((Object)("Found Roles in SPFilter config=" + roles));
        }
        if (roles != null) {
            options.put("ROLES", roles);
        }
        this.roleValidator.intialize(options);
        String samlHandlerChainClass = filterConfig.getInitParameter("SAML_HANDLER_CHAIN_CLASS");
        if (StringUtil.isNullOrEmpty(samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain(samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
        try {
            String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
            Handlers handlers = null;
            handlers = this.picketLinkConfiguration != null ? this.picketLinkConfiguration.getHandlers() : ConfigurationUtil.getHandlers(this.context.getResourceAsStream(handlerConfigFileName));
            this.chain.addAll(HandlerUtil.getHandlers(handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
            chainConfigOptions.put("ROLE_VALIDATOR", this.roleValidator);
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set<SAML2Handler> samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig(handlerChainConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String ignoreSigString = filterConfig.getInitParameter("IGNORE_SIGNATURES");
        if (ignoreSigString != null && !"".equals(ignoreSigString)) {
            this.ignoreSignatures = Boolean.parseBoolean(ignoreSigString);
        }
        if (!this.ignoreSignatures) {
            KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new RuntimeException("PL00092: Null Value:KeyProvider");
            }
            try {
                String keyManagerClassName = keyProvider.getClassName();
                if (keyManagerClassName == null) {
                    throw new RuntimeException("PL00092: Null Value:KeyManager class name");
                }
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), keyManagerClassName);
                this.keyManager = (TrustKeyManager)clazz.newInstance();
                List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProvider);
                this.keyManager.setAuthProperties(authProperties);
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
        if ((gloPage = filterConfig.getInitParameter("LOGOUT_PAGE")) != null && !"".equals(gloPage)) {
            this.logOutPage = gloPage;
        }
    }

    private AuthnRequestType createSAMLRequest(String serviceURL, String identityURL) throws ConfigurationException {
        if (serviceURL == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:serviceURL");
        }
        if (identityURL == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:identityURL");
        }
        SAML2Request saml2Request = new SAML2Request();
        String id = IDGenerator.create("ID_");
        return saml2Request.createAuthnRequestType(id, serviceURL, identityURL, serviceURL);
    }

    protected void sendRequestToIDP(AuthnRequestType authnRequest, String relayState, HttpServletResponse response) throws IOException, SAXException, GeneralSecurityException {
        SAML2Request saml2Request = new SAML2Request();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, baos);
        String samlMessage = PostBindingUtil.base64Encode(baos.toString());
        String destination = authnRequest.getDestination().toASCIIString();
        PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlMessage, relayState), response, true);
    }

    protected void sendToDestination(Document samlDocument, String relayState, String destination, HttpServletResponse response, boolean request) throws IOException, SAXException, GeneralSecurityException {
        if (!this.ignoreSignatures) {
            SAML2Signature samlSignature = new SAML2Signature();
            Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
            if (nextSibling != null) {
                samlSignature.setNextSibling(nextSibling);
            }
            KeyPair keypair = this.keyManager.getSigningKeyPair();
            samlSignature.signSAMLDocument(samlDocument, keypair);
        }
        String samlMessage = PostBindingUtil.base64Encode(DocumentUtil.getDocumentAsString(samlDocument));
        PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlMessage, relayState), response, request);
    }

    protected boolean validate(HttpServletRequest request) throws IOException, GeneralSecurityException {
        return request.getParameter("SAMLResponse") != null;
    }

    protected boolean verifySignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException {
        URL issuerURL;
        Document samlResponse = samlDocumentHolder.getSamlDocument();
        SAML2Object samlObject = samlDocumentHolder.getSamlObject();
        String issuerID = null;
        issuerID = samlObject instanceof StatusResponseType ? ((StatusResponseType)samlObject).getIssuer().getValue() : ((RequestAbstractType)samlObject).getIssuer().getValue();
        if (issuerID == null) {
            throw new IssuerNotTrustedException("PL00092: Null Value:IssuerID missing");
        }
        try {
            issuerURL = new URL(issuerID);
        }
        catch (MalformedURLException e1) {
            throw new IssuerNotTrustedException(e1);
        }
        try {
            PublicKey publicKey = this.keyManager.getValidatingKey(issuerURL.getHost());
            log.trace((Object)"Going to verify signature in the saml response from IDP");
            boolean sigResult = XMLSignatureUtil.validate(samlResponse, publicKey);
            log.trace((Object)("Signature verification=" + sigResult));
            return sigResult;
        }
        catch (TrustKeyConfigurationException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (TrustKeyProcessingException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (MarshalException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        return false;
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            URL url = new URL(issuer);
            String issuerDomain = url.getHost();
            TrustType idpTrust = this.spConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) {
        throw new RuntimeException("PL00102: Processing Exception:This filter does not handle encryption");
    }

    public Principal handleSAMLResponse(HttpServletRequest request, ResponseType responseType) throws ConfigurationException, AssertionExpiredException {
        if (request == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:request");
        }
        if (responseType == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:response type");
        }
        StatusType statusType = responseType.getStatus();
        if (statusType == null) {
            throw new IllegalArgumentException("PL00092: Null Value:Status Type from the IDP");
        }
        String statusValue = statusType.getStatusCode().getValue().toASCIIString();
        if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
            throw new SecurityException("PL00015: IDP Authentication Failed:IDP forbid the user");
        }
        List<ResponseType.RTChoiceType> assertions = responseType.getAssertions();
        if (assertions.size() == 0) {
            throw new IllegalStateException("PL00092: Null Value:No assertions in reply from IDP");
        }
        AssertionType assertion = assertions.get(0).getAssertion();
        boolean expiredAssertion = AssertionUtil.hasExpired(assertion);
        if (expiredAssertion) {
            throw new AssertionExpiredException("PL00079: Assertion has expired:");
        }
        SubjectType subject = assertion.getSubject();
        NameIDType nameID = (NameIDType)subject.getSubType().getBaseID();
        final String userName = nameID.getValue();
        ArrayList<String> roles = new ArrayList<String>();
        AttributeStatementType attributeStatement = (AttributeStatementType)assertion.getStatements().iterator().next();
        List<AttributeStatementType.ASTChoiceType> attList = attributeStatement.getAttributes();
        for (AttributeStatementType.ASTChoiceType obj : attList) {
            AttributeType attr = obj.getAttribute();
            String roleName = (String)attr.getAttributeValue().get(0);
            roles.add(roleName);
        }
        Principal principal = new Principal(){

            public String getName() {
                return userName;
            }
        };
        boolean validRole = this.roleValidator.userInRole(principal, roles);
        if (!validRole) {
            if (this.trace) {
                log.trace((Object)("Invalid role:" + roles));
            }
            principal = null;
        }
        return principal;
    }
}

