/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model.idp;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.model.ModelUtils;
import org.picketlink.as.subsystem.model.idp.IdentityProviderResourceDefinition;
import org.picketlink.as.subsystem.service.FederationService;
import org.picketlink.as.subsystem.service.IdentityProviderService;
import org.picketlink.identity.federation.core.config.IDPConfiguration;

public class IDPWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final IDPWriteAttributeHandler INSTANCE = new IDPWriteAttributeHandler();

    private IDPWriteAttributeHandler() {
        super(new AttributeDefinition[]{IdentityProviderResourceDefinition.ALIAS, IdentityProviderResourceDefinition.EXTERNAL, IdentityProviderResourceDefinition.SUPPORTS_SIGNATURES, IdentityProviderResourceDefinition.SECURITY_DOMAIN, IdentityProviderResourceDefinition.URL, IdentityProviderResourceDefinition.STRICT_POST_BINDING});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode node = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String alias = node.get(ModelElement.COMMON_ALIAS.getName()).asString();
        IdentityProviderService service = (IdentityProviderService)context.getServiceRegistry(true).getRequiredService(IdentityProviderService.createServiceName(alias)).getValue();
        IDPConfiguration updatedIDPConfig = ModelUtils.toIDPConfig(node);
        updatedIDPConfig.setKeyProvider(FederationService.getService(context.getServiceRegistry(true), operation).getKeyProvider());
        updatedIDPConfig.setTrust(((IDPConfiguration)service.getConfiguration()).getTrust());
        updatedIDPConfig.setTrustDomainAlias(((IDPConfiguration)service.getConfiguration()).getTrustDomainAlias());
        service.setConfiguration(updatedIDPConfig);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
    }
}

