/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model.idp;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.picketlink.as.subsystem.model.AbstractResourceAddStepHandler;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.service.IdentityProviderService;
import org.picketlink.identity.federation.core.config.IDPConfiguration;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;

public class TrustDomainAddHandler
extends AbstractResourceAddStepHandler {
    public static final TrustDomainAddHandler INSTANCE = new TrustDomainAddHandler();

    private TrustDomainAddHandler() {
        super(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        IdentityProviderService service;
        KeyProviderType keyProvider;
        String alias = ((Property)operation.get("address").asPropertyList().get(2)).getValue().asString();
        String domain = operation.get(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN_NAME.getName()).asString();
        String certAlias = null;
        if (operation.get(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN_CERT_ALIAS.getName()).isDefined()) {
            certAlias = operation.get(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN_CERT_ALIAS.getName()).asString();
        }
        if ((keyProvider = ((IDPConfiguration)(service = IdentityProviderService.getService(context.getServiceRegistry(true), alias)).getConfiguration()).getKeyProvider()) != null) {
            KeyValueType keyValue = new KeyValueType();
            keyValue.setKey(domain);
            if (certAlias != null) {
                keyValue.setValue(certAlias);
            } else {
                keyValue.setValue(domain);
            }
            keyProvider.add(keyValue);
        }
        ((IDPConfiguration)service.getConfiguration()).addTrustDomain(domain, certAlias);
    }
}

