/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.trust.jbossws.Constants;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPicketLinkTrustHandler<C extends LogicalMessageContext>
implements SOAPHandler {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static Set<QName> headers;
    protected static final String SEC_MGR_LOOKUP = "java:jboss/jaas/";
    protected static final String AUTHZ_MGR_LOOKUP = "java:comp/env/security/authorizationMgr";
    private String securityDomainName;

    public Set<QName> getHeaders() {
        return headers;
    }

    protected ServletContext getServletContext(MessageContext msgContext) {
        return (ServletContext)msgContext.get((Object)"javax.xml.ws.servlet.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSecurityDomainName(MessageContext msgContext) throws ConfigurationException {
        if (this.securityDomainName == null) {
            InputStream is = null;
            try {
                is = this.getJBossWeb(this.getServletContext(msgContext));
                if (is != null) {
                    Document document = DocumentUtil.getDocument((InputStream)is);
                    this.securityDomainName = DocumentUtil.getChildElement((Element)document.getDocumentElement(), (QName)new QName("security-domain")).getTextContent();
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (this.securityDomainName == null) {
            throw logger.securityDomainNotFound();
        }
        return this.securityDomainName;
    }

    private InputStream getJBossWeb(ServletContext context) {
        if (context == null) {
            throw logger.nullValueError("Servlet Context");
        }
        return context.getResourceAsStream("/WEB-INF/jboss-web.xml");
    }

    protected Element getSecurityHeaderElement(Document document) {
        Element element = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Util.addNamespace(element, "ds", "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    protected void trace(MessageContext msgContext) {
        if (logger.isTraceEnabled() && msgContext instanceof SOAPMessageContext) {
            SOAPMessageContext soapMessageContext = (SOAPMessageContext)msgContext;
            logger.trace("WSDL_PORT=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.port"));
            logger.trace("WSDL_OPERATION=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.operation"));
            logger.trace("WSDL_INTERFACE=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.interface"));
            logger.trace("WSDL_SERVICE=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.service"));
        }
    }

    protected String getUsername(Element nameID) {
        String username = nameID.getNodeValue();
        if (username == null) {
            NodeList childNodes = nameID.getChildNodes();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() != 3) continue;
                username = childNode.getNodeValue();
            }
        }
        return username;
    }

    protected Element getAssertionFromSubject() {
        Element assertion = null;
        Subject subject = SecurityActions.getAuthenticatedSubject();
        if (subject == null) {
            logger.trace("No authentication Subject found, cannot provide any user roles!");
            return assertion;
        }
        Set<Object> creds = subject.getPublicCredentials();
        if (creds != null) {
            for (Object cred : creds) {
                if (!(cred instanceof SamlCredential)) continue;
                SamlCredential samlCredential = (SamlCredential)cred;
                try {
                    assertion = samlCredential.getAssertionAsElement();
                }
                catch (ProcessingException e) {
                    logger.samlAssertionPasingFailed((Throwable)e);
                }
                break;
            }
        }
        return assertion;
    }

    protected Object lookupJNDI(String str) {
        try {
            InitialContext context = new InitialContext();
            return context.lookup(str);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean handleMessage(MessageContext msgContext) {
        Boolean outbound = (Boolean)msgContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot obtain required property: javax.xml.ws.handler.message.outbound");
        }
        return outbound != false ? this.handleOutbound(msgContext) : this.handleInbound(msgContext);
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        return true;
    }

    protected boolean handleInbound(MessageContext msgContext) {
        return true;
    }

    public boolean handleFault(MessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.add(Constants.WSSE_HEADER_QNAME);
        headers = Collections.unmodifiableSet(set);
    }
}

