/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.navigation.Pages;
import org.picketlink.identity.seam.federation.ExternalAuthenticator;
import org.picketlink.identity.seam.federation.configuration.Configuration;
import org.picketlink.identity.seam.federation.configuration.OpenIdConfiguration;
import org.picketlink.identity.seam.federation.configuration.SamlConfiguration;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Name(value="org.jboss.seam.navigation.pages")
@Install(precedence=10, classDependencies={"javax.faces.context.FacesContext"})
@Startup
public class PagesSupportingExternalAuthentication
extends Pages {
    public void redirectToLoginView() {
        this.notLoggedIn();
        HttpServletRequest httpRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        StringBuffer returnUrl = httpRequest.getRequestURL();
        ExternalAuthenticator externalAuthenticator = (ExternalAuthenticator)Component.getInstance(ExternalAuthenticator.class);
        externalAuthenticator.setReturnUrl(returnUrl.toString());
        ServiceProvider serviceProvider = Configuration.instance().getServiceProvider();
        SamlConfiguration samlConfiguration = serviceProvider.getSamlConfiguration();
        if (samlConfiguration != null && samlConfiguration.getDefaultIdentityProvider() != null) {
            externalAuthenticator.samlSignOn(samlConfiguration.getDefaultIdentityProvider().getEntityId());
        } else {
            OpenIdConfiguration openIdConfiguration = serviceProvider.getOpenIdConfiguration();
            if (openIdConfiguration != null && openIdConfiguration.getDefaultOpenIdProvider() != null) {
                externalAuthenticator.openIdSignOn(openIdConfiguration.getDefaultOpenIdProvider());
            } else {
                if (this.getLoginViewId() == null) {
                    throw new RuntimeException("Login view id not specified in pages.xml.");
                }
                HashMap<String, StringBuffer> parameters = new HashMap<String, StringBuffer>();
                parameters.put("returnUrl", returnUrl);
                FacesManager.instance().redirect(this.getLoginViewId(), parameters, false);
            }
        }
    }
}

