/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.picketlink.identity.seam.federation.RequestContext;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;

@Name(value="org.picketlink.identity.seam.federation.requests")
@AutoCreate
@Scope(value=ScopeType.SESSION)
public class Requests {
    private Map<String, RequestContext> requests = new HashMap<String, RequestContext>();
    @Logger
    private Log log;

    public void addRequest(String id, SamlIdentityProvider identityProvider, String urlToRedirectToAfterLogin) {
        this.requests.put(id, new RequestContext(id, identityProvider, urlToRedirectToAfterLogin));
    }

    public RequestContext getRequest(String id) {
        return this.requests.get(id);
    }

    public void removeRequest(String id) {
        this.requests.remove(id);
    }

    public void redirect(String id, HttpServletResponse response) {
        String requestURL = this.requests.get(id).getUrlToRedirectToAfterLogin();
        if (requestURL == null) {
            throw new RuntimeException("Couldn't find URL to redirect to for request " + id);
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Redirecting to " + requestURL), new Object[0]);
            }
            response.sendRedirect(requestURL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

