/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.web.config.SecurityActions;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class PropertiesConfigurationProvider
implements SAMLConfigurationProvider {
    public static final String IDP_FILE = "idp_config.properties";
    public static final String SP_FILE = "sp_config.properties";

    public IDPType getIDPConfiguration() throws ProcessingException {
        InputStream is = SecurityActions.loadStream(this.getClass(), IDP_FILE);
        if (is == null) {
            throw new IllegalStateException("PL00092: Null Value:idp_config.properties");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        IDPType idp = new IDPType();
        idp.setIdentityURL(props.getProperty("idp.url"));
        String domains = props.getProperty("domains");
        if (StringUtil.isNotNull((String)domains)) {
            TrustType trustType = new TrustType();
            trustType.setDomains(domains);
            idp.setTrust(trustType);
        }
        return idp;
    }

    public SPType getSPConfiguration() throws ProcessingException {
        InputStream is = SecurityActions.loadStream(this.getClass(), SP_FILE);
        if (is == null) {
            throw new IllegalStateException("PL00092: Null Value:sp_config.properties");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        SPType sp = new SPType();
        sp.setIdentityURL(props.getProperty("idp.url"));
        sp.setServiceURL("service.url");
        String domains = props.getProperty("domains");
        if (StringUtil.isNotNull((String)domains)) {
            TrustType trustType = new TrustType();
            trustType.setDomains(domains);
            sp.setTrust(trustType);
        }
        return sp;
    }
}

