/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.VirtualExecutorService;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.client.ClientContextImpl;
import org.projectodd.stilts.stomp.client.ClientListener;
import org.projectodd.stilts.stomp.client.ClientSubscription;
import org.projectodd.stilts.stomp.client.ClientTransaction;
import org.projectodd.stilts.stomp.client.ReceiptFuture;
import org.projectodd.stilts.stomp.client.StompClientPipelineFactory;
import org.projectodd.stilts.stomp.client.SubscriptionBuilder;
import org.projectodd.stilts.stomp.client.SubscriptionBuilderImpl;
import org.projectodd.stilts.stomp.protocol.StompControlFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;

public class StompClient {
    public static final long DEFAULT_CONNECT_WAIT_TIME = 5000L;
    public static final long DEFAULT_DISCONNECT_WAIT_TIME = 5000L;
    private static Logger log = Logger.getLogger(StompClient.class);
    private static final Callable<Void> NOOP = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            return null;
        }
    };
    private AtomicInteger receiptCounter = new AtomicInteger();
    private ConcurrentHashMap<String, ReceiptFuture> receiptHandlers = new ConcurrentHashMap(20);
    private AtomicInteger transactionCounter = new AtomicInteger();
    private Map<String, ClientTransaction> transactions = new HashMap<String, ClientTransaction>();
    private AtomicInteger subscriptionCounter = new AtomicInteger();
    private final Map<String, ClientSubscription> subscriptions = new HashMap<String, ClientSubscription>();
    private final Object stateLock = new Object();
    private State connectionState;
    private ClientBootstrap bootstrap;
    private ClientListener clientListener;
    private Executor executor;
    private boolean destroyExecutor = false;
    private Channel channel;
    private InetSocketAddress serverAddress;
    private StompFrame.Version version = StompFrame.Version.VERSION_1_0;
    private boolean useWebSockets = false;

    public StompClient(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public StompClient(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        if (scheme.startsWith("stomp")) {
            int port = 8675;
            String host = uri.getHost();
            int uriPort = uri.getPort();
            if (uriPort > 0) {
                port = uriPort;
            }
            this.serverAddress = new InetSocketAddress(host, port);
            if (scheme.endsWith("+ws")) {
                this.useWebSockets = true;
            }
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public StompFrame.Version getVersion() {
        return this.version;
    }

    void setVersion(StompFrame.Version version) {
        this.version = version;
    }

    public boolean isConnected() {
        return this.getConnectionState() == State.CONNECTED;
    }

    public boolean isDisconnected() {
        return this.getConnectionState() == State.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectionState(State connectionState) {
        Object object = this.stateLock;
        synchronized (object) {
            this.connectionState = connectionState;
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForConnected(long waitTime) throws InterruptedException, StompException {
        if (this.connectionState == State.CONNECTING) {
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.wait(waitTime);
            }
        }
        if (this.connectionState != State.CONNECTED) {
            throw new StompException("Connection timed out.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForDisconnected(long waitTime) throws InterruptedException, StompException {
        if (this.connectionState == State.DISCONNECTING) {
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.wait(waitTime);
            }
        }
        if (this.connectionState != State.DISCONNECTED) {
            throw new StompException("Connection timed out.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getConnectionState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionState;
        }
    }

    void messageReceived(StompMessage message) {
        ClientSubscription subscription;
        boolean handled = false;
        String subscriptionId = message.getHeaders().get("subscription");
        if (subscriptionId != null && (subscription = this.subscriptions.get(subscriptionId)) != null) {
            handled = subscription.messageReceived(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void errorReceived(StompMessage message) {
        log.error((Object)message.getContentAsString());
        String receiptId = message.getHeaders().get("receipt-id");
        if (receiptId != null) {
            this.receiptReceived(receiptId, message);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.connectionState == State.CONNECTING) {
                this.connectionState = State.DISCONNECTED;
                this.stateLock.notifyAll();
            }
        }
    }

    public void connect() throws InterruptedException, StompException {
        this.connect(5000L);
    }

    public void connect(long waitTime) throws InterruptedException, StompException {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(4);
            this.destroyExecutor = true;
        }
        this.bootstrap = new ClientBootstrap();
        ChannelPipelineFactory factory = this.createPipelineFactory();
        this.bootstrap.setPipelineFactory(factory);
        this.bootstrap.setFactory((ChannelFactory)this.createChannelFactory());
        this.setConnectionState(State.CONNECTING);
        this.channel = this.bootstrap.connect((SocketAddress)this.serverAddress).await().getChannel();
        this.waitForConnected(waitTime);
        if (this.connectionState == State.CONNECTED) {
            log.info((Object)"Connected");
            if (this.clientListener != null) {
                this.clientListener.connected(this);
            }
        } else {
            log.info((Object)"Failed to connect");
            this.disconnect();
        }
    }

    String getNextTransactionId() {
        return "transaction-" + this.transactionCounter.getAndIncrement();
    }

    public void disconnect() throws InterruptedException, StompException {
        this.disconnect(5000L);
    }

    public void disconnect(long waitTime) throws InterruptedException, StompException {
        this.setConnectionState(State.DISCONNECTING);
        this.channel.close();
        this.waitForDisconnected(waitTime);
        if (this.destroyExecutor) {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.destroyExecutor = false;
        }
    }

    public SubscriptionBuilder subscribe(String destination) {
        return new SubscriptionBuilderImpl(this, destination);
    }

    public void send(StompMessage message) {
        StompFrame frame = StompFrames.newSendFrame((StompMessage)message);
        this.sendFrame(frame);
    }

    ClientSubscription subscribe(SubscriptionBuilderImpl builder) throws InterruptedException, ExecutionException {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.SUBSCRIBE, builder.getHeaders());
        String subscriptionId = this.getNextSubscriptionId();
        frame.setHeader("id", subscriptionId);
        ReceiptFuture future = this.sendFrame((StompFrame)frame);
        future.await();
        if (future.isError()) {
            return null;
        }
        Executor executor = builder.getExecutor();
        if (executor == null) {
            executor = this.getExecutor();
        }
        ClientSubscription subscription = new ClientSubscription(this, subscriptionId, builder.getMessageHandler(), executor);
        this.subscriptions.put(subscription.getId(), subscription);
        return subscription;
    }

    void unsubscribe(ClientSubscription subscription) throws InterruptedException, ExecutionException {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.UNSUBSCRIBE);
        frame.setHeader("id", subscription.getId());
        this.sendFrame((StompFrame)frame).await();
        subscription.setActive(false);
    }

    String getNextSubscriptionId() {
        return "subscription-" + this.subscriptionCounter.getAndIncrement();
    }

    ReceiptFuture sendFrame(StompFrame frame) {
        return this.sendFrame(frame, NOOP);
    }

    ReceiptFuture sendFrame(StompFrame frame, Callable<Void> receiptHandler) {
        ReceiptFuture future = null;
        String receiptId = this.getNextReceiptId();
        frame.setHeader("receipt", receiptId);
        future = new ReceiptFuture(receiptHandler);
        this.receiptHandlers.put(receiptId, future);
        this.channel.write((Object)frame);
        return future;
    }

    String getNextReceiptId() {
        return "receipt-" + this.receiptCounter.getAndIncrement();
    }

    void receiptReceived(String receiptId) {
        this.receiptReceived(receiptId, null);
    }

    void receiptReceived(String receiptId, StompMessage message) {
        ReceiptFuture future = this.receiptHandlers.remove(receiptId);
        if (future != null) {
            try {
                future.received(message);
            }
            catch (Exception e) {
                log.error((Object)("Error during receipt of '" + receiptId + "'"), (Throwable)e);
            }
        }
    }

    public ClientTransaction begin() throws StompException {
        String transactionId;
        block4: {
            transactionId = this.getNextTransactionId();
            StompControlFrame frame = StompFrames.newBeginFrame((String)transactionId);
            ReceiptFuture future = this.sendFrame((StompFrame)frame);
            future.await();
            if (!future.isError()) break block4;
            return null;
        }
        try {
            ClientTransaction transaction = new ClientTransaction(this, transactionId);
            this.transactions.put(transaction.getId(), transaction);
            return transaction;
        }
        catch (InterruptedException e) {
            throw new StompException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new StompException((Throwable)e);
        }
    }

    public void abort(String transactionId) throws StompException {
        StompControlFrame frame = StompFrames.newAbortFrame((String)transactionId);
        ReceiptFuture future = this.sendFrame((StompFrame)frame);
        try {
            future.await();
        }
        catch (InterruptedException e) {
            throw new StompException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new StompException((Throwable)e);
        }
    }

    public void commit(String transactionId) throws StompException {
        StompControlFrame frame = StompFrames.newCommitFrame((String)transactionId);
        ReceiptFuture future = this.sendFrame((StompFrame)frame);
        try {
            future.await();
        }
        catch (InterruptedException e) {
            throw new StompException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new StompException((Throwable)e);
        }
    }

    protected ChannelPipelineFactory createPipelineFactory() {
        return new StompClientPipelineFactory(this, new ClientContextImpl(this), this.useWebSockets);
    }

    protected ClientSocketChannelFactory createChannelFactory() {
        VirtualExecutorService bossExecutor = new VirtualExecutorService(this.executor);
        VirtualExecutorService workerExecutor = new VirtualExecutorService(this.executor);
        return new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

