/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.protocol;

import java.security.NoSuchAlgorithmException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.UpstreamChannelStateEvent;
import org.projectodd.stilts.stomp.client.StompClient;
import org.projectodd.stilts.stomp.client.protocol.AbstractClientControlFrameHandler;
import org.projectodd.stilts.stomp.client.protocol.ClientContext;
import org.projectodd.stilts.stomp.client.protocol.StompDisconnectionNegotiator;
import org.projectodd.stilts.stomp.protocol.StompControlFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;

public class StompConnectionNegotiator
extends AbstractClientControlFrameHandler {
    private String host;

    public StompConnectionNegotiator(ClientContext clientContext, String host) throws NoSuchAlgorithmException {
        super(clientContext, StompFrame.Command.CONNECTED);
        this.host = host;
    }

    public void channelConnected(ChannelHandlerContext context, ChannelStateEvent e) throws Exception {
        StompControlFrame frame = new StompControlFrame(StompFrame.Command.CONNECT);
        frame.setHeader("host", this.host);
        frame.setHeader("accept-version", StompFrame.Version.supportedVersions());
        Channels.write((Channel)context.getChannel(), (Object)frame);
    }

    @Override
    protected void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        String version = frame.getHeader("version");
        if (version != null) {
            this.getClientContext().setVersion(StompFrame.Version.forVersionString((String)version));
        }
        Channel channel = channelContext.getChannel();
        channelContext.sendUpstream((ChannelEvent)new UpstreamChannelStateEvent(channel, ChannelState.CONNECTED, (Object)channel.getRemoteAddress()));
        channelContext.getPipeline().replace((ChannelHandler)this, "stomp-disconnection-negotiator", (ChannelHandler)new StompDisconnectionNegotiator(this.getClientContext()));
        this.getClientContext().setConnectionState(StompClient.State.CONNECTED);
    }
}

