/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.protocol.websockets;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;

public class WebSocketHttpResponseDecoder
extends ReplayingDecoder<VoidEnum> {
    private final Pattern statusLineRegexp = Pattern.compile("^HTTP/([0-9]+\\.[0-9]+) +([0-9][0-9][0-9]) +(.*)$");

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        int nonNewlineBytes = buffer.bytesBefore((byte)10);
        ChannelBuffer firstLine = buffer.readBytes(nonNewlineBytes + 1);
        String line = firstLine.toString(Charset.forName("UTF-8")).trim();
        Matcher matcher = this.statusLineRegexp.matcher(line);
        if (matcher.matches()) {
            int status = Integer.parseInt(matcher.group(2));
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)status));
            if (status == 101) {
                if ((response = this.readHeaders((HttpResponse)response, buffer)) == null) {
                    return null;
                }
                this.readChallengeSolution((HttpResponse)response, buffer);
                return response;
            }
        }
        return null;
    }

    protected HttpResponse readHeaders(HttpResponse response, ChannelBuffer buffer) {
        int nonNewlineBytes = buffer.bytesBefore((byte)10);
        while (nonNewlineBytes > 0) {
            ChannelBuffer lineBuffer = buffer.readBytes(nonNewlineBytes + 1);
            String line = lineBuffer.toString(Charset.forName("UTF-8")).trim();
            if (line.length() == 0) {
                return response;
            }
            int colonLoc = line.indexOf(58);
            if (colonLoc >= 0) {
                String name = line.substring(0, colonLoc).trim().toLowerCase();
                String value = line.substring(colonLoc + 1).trim();
                response.addHeader(name, (Object)value);
            }
            nonNewlineBytes = buffer.bytesBefore((byte)10);
        }
        return null;
    }

    protected void readChallengeSolution(HttpResponse response, ChannelBuffer buffer) {
        byte[] solution = new byte[16];
        buffer.readBytes(solution);
        response.setContent(ChannelBuffers.copiedBuffer((byte[])solution));
    }
}

