/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.projectodd.stilts.stomp.StompMessageFactory;
import org.projectodd.stilts.stomp.client.ClientStompMessageFactory;
import org.projectodd.stilts.stomp.client.StompClient;
import org.projectodd.stilts.stomp.client.protocol.ClientContext;
import org.projectodd.stilts.stomp.client.protocol.ClientMessageHandler;
import org.projectodd.stilts.stomp.client.protocol.ClientReceiptHandler;
import org.projectodd.stilts.stomp.client.protocol.StompConnectionNegotiator;
import org.projectodd.stilts.stomp.client.protocol.websockets.WebSocketConnectionNegotiator;
import org.projectodd.stilts.stomp.client.protocol.websockets.WebSocketHttpResponseDecoder;
import org.projectodd.stilts.stomp.protocol.StompFrameDecoder;
import org.projectodd.stilts.stomp.protocol.StompFrameEncoder;
import org.projectodd.stilts.stomp.protocol.StompMessageDecoder;
import org.projectodd.stilts.stomp.protocol.StompMessageEncoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketStompFrameDecoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketStompFrameEncoder;

public class StompClientPipelineFactory
implements ChannelPipelineFactory {
    private StompClient client;
    private ClientContext clientContext;
    private boolean useWebSockets;

    public StompClientPipelineFactory(StompClient client, ClientContext clientContext, boolean useWebSockets) {
        this.client = client;
        this.clientContext = clientContext;
        this.useWebSockets = useWebSockets;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.useWebSockets) {
            pipeline.addLast("http-encoder", (ChannelHandler)new HttpRequestEncoder());
            pipeline.addLast("http-decoder", (ChannelHandler)new WebSocketHttpResponseDecoder());
            pipeline.addLast("websocket-connection-negotiator", (ChannelHandler)new WebSocketConnectionNegotiator("localhost", 8675));
            pipeline.addLast("stomp-frame-decoder", (ChannelHandler)new WebSocketStompFrameDecoder());
            pipeline.addLast("stomp-frame-encoder", (ChannelHandler)new WebSocketStompFrameEncoder());
        } else {
            pipeline.addLast("stomp-frame-decoder", (ChannelHandler)new StompFrameDecoder());
            pipeline.addLast("stomp-frame-encoder", (ChannelHandler)new StompFrameEncoder());
        }
        pipeline.addLast("stomp-connection-negotiator", (ChannelHandler)new StompConnectionNegotiator(this.clientContext, "localhost"));
        pipeline.addLast("stomp-client-receipt", (ChannelHandler)new ClientReceiptHandler(this.clientContext));
        pipeline.addLast("stomp-message-encoder", (ChannelHandler)new StompMessageEncoder());
        pipeline.addLast("stomp-message-decoder", (ChannelHandler)new StompMessageDecoder((StompMessageFactory)new ClientStompMessageFactory(this.client)));
        pipeline.addLast("stomp-client-message-handler", (ChannelHandler)new ClientMessageHandler(this.clientContext));
        return pipeline;
    }
}

