/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.protocol.websockets;

import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.projectodd.stilts.stomp.client.protocol.websockets.WebSocketHttpResponseDecoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketChallenge;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketDisconnectionNegotiator;

public class WebSocketConnectionNegotiator
extends SimpleChannelUpstreamHandler {
    private static final Logger log = Logger.getLogger((String)"stomp.proto.client.websocket");
    private String host;
    private int port;
    private WebSocketChallenge challenge;
    private ChannelStateEvent connectedEvent;

    public WebSocketConnectionNegotiator(String host, int port) throws NoSuchAlgorithmException {
        this.host = host;
        this.port = port;
        this.challenge = new WebSocketChallenge();
    }

    public void channelConnected(ChannelHandlerContext context, ChannelStateEvent e) throws Exception {
        log.info((Object)("Starting websockets connection " + e.getClass()));
        String url = "stomp+ws://" + this.host + ":" + this.port + "/";
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, url);
        request.addHeader("Connection", (Object)"Upgrade");
        request.addHeader("Upgrade", (Object)"WebSocket");
        request.addHeader("Host", (Object)(this.host + ":" + this.port));
        request.addHeader("Sec-WebSocket-Protocol", (Object)"stomp");
        request.addHeader("Sec-WebSocket-Key1", (Object)this.challenge.getKey1String());
        request.addHeader("Sec-WebSocket-Key2", (Object)this.challenge.getKey2String());
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)6);
        buffer.writeBytes(this.challenge.getKey3());
        buffer.writeByte(13);
        buffer.writeByte(10);
        request.setContent(buffer);
        Channel channel = context.getChannel();
        this.connectedEvent = e;
        Channels.write((Channel)channel, (Object)request);
    }

    public void messageReceived(ChannelHandlerContext context, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e.getMessage();
            ChannelBuffer content = response.getContent();
            System.err.println("READABLE: " + content.readableBytes());
            byte[] challengeResponse = new byte[16];
            content.readBytes(challengeResponse);
            if (this.challenge.verify(challengeResponse)) {
                ChannelPipeline pipeline = context.getPipeline();
                if (pipeline.get(WebSocketHttpResponseDecoder.class) != null) {
                    pipeline.replace(WebSocketHttpResponseDecoder.class, "websockets-decoder", (ChannelHandler)new WebSocketFrameDecoder());
                } else {
                    pipeline.addFirst("websockets-decoder", (ChannelHandler)new WebSocketFrameDecoder());
                }
                if (pipeline.get(HttpRequestEncoder.class) != null) {
                    pipeline.replace(HttpRequestEncoder.class, "websockets-encoder", (ChannelHandler)new WebSocketFrameEncoder());
                } else {
                    pipeline.addAfter("websockets-decoder", "websockets-encoder", (ChannelHandler)new WebSocketFrameEncoder());
                }
                context.sendUpstream((ChannelEvent)this.connectedEvent);
                pipeline.replace((ChannelHandler)this, "websocket-disconnection-negotiator", (ChannelHandler)new WebSocketDisconnectionNegotiator());
            }
        } else {
            super.messageReceived(context, e);
        }
    }
}

