/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.nio.charset.Charset;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.handler.codec.embedder.EncoderEmbedder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.StompMessages;
import org.projectodd.stilts.stomp.protocol.StompContentFrame;
import org.projectodd.stilts.stomp.protocol.StompMessageEncoder;

public class StompMessageEncoderTest {
    private EncoderEmbedder<StompContentFrame> encoder;

    @Before
    public void setUp() {
        this.encoder = new EncoderEmbedder(new ChannelDownstreamHandler[]{new StompMessageEncoder()});
    }

    @Test
    public void testNonMessage() throws Exception {
        boolean result = this.encoder.offer((Object)"Howdy");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"Howdy", (Object)this.encoder.poll());
    }

    @Test
    public void testMessage() throws Exception {
        StompMessage message = StompMessages.createStompMessage((String)"/queues/one", (String)"sasquatch!");
        boolean result = this.encoder.offer((Object)message);
        Assert.assertTrue((boolean)result);
        StompContentFrame frame = (StompContentFrame)this.encoder.poll();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)"/queues/one", (Object)frame.getHeader("destination"));
        Assert.assertEquals((Object)"sasquatch!", (Object)frame.getContent().toString(Charset.forName("UTF-8")));
    }
}

