/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.websocket.ietf00;

import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketFrame;

@ChannelHandler.Sharable
public class Ietf00WebSocketFrameEncoder
extends OneToOneEncoder {
    private static final Logger log = Logger.getLogger((String)"stilts.websockets.ietf00.encoder");

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            WebSocketFrame.FrameType frameType = frame.getType();
            switch (frameType) {
                case CLOSE: {
                    log.info((Object)"encode close");
                    ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(2);
                    encoded.writeByte(128);
                    encoded.writeByte(255);
                    return encoded;
                }
                case TEXT: {
                    log.info((Object)"encode text");
                    ChannelBuffer data = frame.getBinaryData();
                    ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), data.readableBytes() + 2);
                    encoded.writeByte(0);
                    encoded.writeBytes(data, data.readableBytes());
                    encoded.writeByte(-1);
                    return encoded;
                }
                case BINARY: {
                    log.info((Object)"encode binary");
                    ChannelBuffer data = frame.getBinaryData();
                    int dataLen = data.readableBytes();
                    ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), dataLen + 5);
                    encoded.writeByte(-128);
                    encoded.writeByte((int)((byte)(dataLen >>> 28 & 0x7F | 0x80)));
                    encoded.writeByte((int)((byte)(dataLen >>> 14 & 0x7F | 0x80)));
                    encoded.writeByte((int)((byte)(dataLen >>> 7 & 0x7F | 0x80)));
                    encoded.writeByte((int)((byte)(dataLen & 0x7F)));
                    encoded.writeBytes(data, dataLen);
                    return encoded;
                }
            }
        }
        return msg;
    }
}

