/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.websocket.ietf07;

import java.nio.ByteOrder;
import java.security.SecureRandom;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketFrame;

public class Ietf07WebSocketFrameEncoder
extends OneToOneEncoder {
    private static Logger log = Logger.getLogger(Ietf07WebSocketFrameEncoder.class);
    private SecureRandom random;

    public Ietf07WebSocketFrameEncoder(boolean shouldMask) {
        if (shouldMask) {
            this.random = new SecureRandom();
        }
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            log.info((Object)("ENCODE " + msg));
            WebSocketFrame frame = (WebSocketFrame)msg;
            WebSocketFrame.FrameType frameType = frame.getType();
            log.infof("encoding: %s", (Object)frameType);
            int opcode = this.encodeOpcode(frameType);
            log.infof("encoded opcode: %d", (Object)opcode);
            ChannelBuffer data = frame.getBinaryData();
            int dataLen = data.readableBytes();
            ChannelBuffer encoded = ChannelBuffers.dynamicBuffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)(data.readableBytes() + 32));
            byte firstByte = (byte)opcode;
            firstByte = (byte)(firstByte | 0x80);
            log.infof("encode byte1: %x", (Object)firstByte);
            encoded.writeByte((int)firstByte);
            log.info((Object)("Encode length=" + dataLen));
            if (dataLen <= 125) {
                encoded.writeByte((int)this.applyMaskBit(dataLen));
            } else if (dataLen < 65535) {
                encoded.writeByte((int)this.applyMaskBit(126));
                encoded.writeShort(dataLen);
            } else {
                encoded.writeByte((int)this.applyMaskBit(127));
                encoded.writeInt(dataLen);
            }
            if (this.shouldMask()) {
                byte[] mask = this.getMask();
                encoded.writeBytes(mask);
                this.applyDataMask(mask, data);
            }
            encoded.writeBytes(data);
            return encoded;
        }
        return msg;
    }

    protected int encodeOpcode(WebSocketFrame.FrameType frameType) {
        switch (frameType) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        return -1;
    }

    protected byte applyMaskBit(int value) {
        if (this.shouldMask()) {
            return (byte)(value | 0x80);
        }
        return (byte)value;
    }

    protected void applyDataMask(byte[] mask, ChannelBuffer data) {
        if (!this.shouldMask()) {
            return;
        }
        int dataLen = data.readableBytes();
        data.markReaderIndex();
        for (int i = 0; i < dataLen; ++i) {
            byte cur = data.getByte(i);
            cur = (byte)(cur ^ mask[i % 4]);
            data.setByte(i, (int)cur);
        }
        data.resetReaderIndex();
    }

    protected byte[] getMask() {
        byte[] mask = new byte[4];
        this.random.nextBytes(mask);
        return mask;
    }

    protected boolean shouldMask() {
        return this.random != null;
    }
}

