/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.projectodd.stilts.stomp.DefaultHeaders;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;

public class DefaultStompMessage
implements StompMessage {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private Headers headers;
    private ChannelBuffer content;
    private boolean isError = false;

    public DefaultStompMessage() {
        this((Headers)new DefaultHeaders(), ChannelBuffers.EMPTY_BUFFER);
    }

    public DefaultStompMessage(Headers headers, ChannelBuffer content) {
        this(headers, content, false);
    }

    public DefaultStompMessage(Headers headers, String content) {
        this(headers, ChannelBuffers.copiedBuffer((byte[])content.getBytes()), false);
    }

    public DefaultStompMessage(Headers headers, String content, boolean isError) {
        this(headers, ChannelBuffers.copiedBuffer((byte[])content.getBytes()), isError);
    }

    public DefaultStompMessage(Headers headers, ChannelBuffer content, boolean isError) {
        this.headers = headers;
        this.content = content;
        this.isError = isError;
    }

    public String getId() {
        return this.headers.get("message-id");
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public boolean isError() {
        return this.isError;
    }

    public String getDestination() {
        return this.headers.get("destination");
    }

    public void setDestination(String destination) {
        this.headers.put("destination", destination);
    }

    public String getContentType() {
        return this.headers.get("content-type");
    }

    public void setContentType(String contentType) {
        this.headers.put("content-type", contentType);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setContent(ChannelBuffer content) {
        this.content = content;
    }

    public ChannelBuffer getContent() {
        return ChannelBuffers.wrappedBuffer((ChannelBuffer)this.content);
    }

    public String getContentAsString() {
        return this.content.toString(UTF_8);
    }

    public void setContentAsString(String content) {
        this.content = ChannelBuffers.copiedBuffer((byte[])content.getBytes());
    }

    public String toString() {
        return "[StompMessage: headers=" + this.headers + "\n  content=" + this.getContentAsString() + "]";
    }

    public void ack() throws StompException {
        throw new UnsupportedOperationException("ACK");
    }

    public void ack(String transactionId) throws StompException {
        throw new UnsupportedOperationException("ACK");
    }

    public void nack() throws StompException {
        throw new UnsupportedOperationException("ACK");
    }

    public void nack(String transactionId) throws StompException {
        throw new UnsupportedOperationException("NACK");
    }

    public StompMessage duplicate() {
        return new DefaultStompMessage(this.headers.duplicate(), ChannelBuffers.wrappedBuffer((ChannelBuffer)this.content), this.isError);
    }
}

