/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.nio.charset.Charset;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.projectodd.stilts.stomp.protocol.FrameHeader;
import org.projectodd.stilts.stomp.protocol.StompContentFrame;
import org.projectodd.stilts.stomp.protocol.StompControlFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;

public class StompFrameCodec {
    public static final StompFrameCodec INSTANCE = new StompFrameCodec();
    private static final int HEADER_ESTIMATE = 1024;
    private static final byte[] HEADER_DELIM = ":".getBytes();
    private static final byte NEWLINE = 10;
    private static final byte NULL = 0;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static Logger log = Logger.getLogger(StompFrameCodec.class);

    public StompFrame decode(ChannelBuffer buffer) throws Exception {
        FrameHeader header = this.decodeHeader(buffer);
        if (header == null) {
            return null;
        }
        int len = header.getContentLength();
        ChannelBuffer content = null;
        content = len <= 0 ? this.readUntilNull(buffer) : this.readUntil(buffer, len);
        StompFrame frame = null;
        if (content != null) {
            frame = header.isContentFrame() ? new StompContentFrame(header, content) : new StompControlFrame(header);
        }
        return frame;
    }

    protected ChannelBuffer readUntilNull(ChannelBuffer buffer) {
        int nonNullBytes = buffer.bytesBefore((byte)0);
        ChannelBuffer content = null;
        content = nonNullBytes == 0 ? ChannelBuffers.EMPTY_BUFFER : buffer.readBytes(nonNullBytes);
        buffer.readByte();
        return content;
    }

    protected ChannelBuffer readUntil(ChannelBuffer buffer, int len) {
        if (buffer.readableBytes() < len + 1) {
            return null;
        }
        ChannelBuffer content = buffer.readBytes(len);
        buffer.readByte();
        return content;
    }

    protected FrameHeader decodeHeader(ChannelBuffer buffer) {
        int nonNewLineBytes;
        FrameHeader header = null;
        while (buffer.readable() && (nonNewLineBytes = buffer.bytesBefore((byte)10)) >= 0) {
            if (nonNewLineBytes == 0) {
                buffer.readByte();
                break;
            }
            if (nonNewLineBytes < 0) continue;
            ChannelBuffer line = buffer.readBytes(nonNewLineBytes);
            buffer.readByte();
            header = this.processHeaderLine(header, line.toString(UTF_8));
        }
        return header;
    }

    protected void logBytes(String name, Object o) {
        StringBuilder bytes = new StringBuilder();
        if (o instanceof ChannelBuffer) {
            ChannelBuffer buffer = (ChannelBuffer)o;
            int readable = buffer.readableBytes();
            for (int i = 0; i < readable; ++i) {
                bytes.append("[" + buffer.getByte(buffer.readerIndex() + i) + "] ");
            }
            log.debug((Object)("* '" + name + "' bytes: " + bytes + " ## "));
        }
    }

    protected FrameHeader processHeaderLine(FrameHeader header, String line) {
        if (header == null) {
            header = new FrameHeader();
            StompFrame.Command command = StompFrame.Command.valueOf(line);
            header.setCommand(command);
            return header;
        }
        int colonLoc = line.indexOf(":");
        if (colonLoc > 0) {
            String name = line.substring(0, colonLoc);
            String value = line.substring(colonLoc + 1);
            header.set(name, value);
        }
        return header;
    }

    public ChannelBuffer encode(StompFrame frame) throws Exception {
        ChannelBuffer buffer = this.newBuffer(frame);
        this.writeHeader(frame, buffer);
        this.writeContent(frame, buffer);
        return buffer;
    }

    protected ChannelBuffer newBuffer(StompFrame frame) {
        if (frame instanceof StompContentFrame) {
            return ChannelBuffers.dynamicBuffer((int)(1024 + ((StompContentFrame)frame).getContent().capacity()));
        }
        return ChannelBuffers.dynamicBuffer((int)1024);
    }

    protected void writeHeader(StompFrame frame, ChannelBuffer buffer) {
        buffer.writeBytes(frame.getCommand().getBytes());
        buffer.writeByte(10);
        Set<String> headerNames = frame.getHeaderNames();
        for (String name : headerNames) {
            if (name.equalsIgnoreCase("content-length")) continue;
            buffer.writeBytes(name.getBytes());
            buffer.writeBytes(HEADER_DELIM);
            buffer.writeBytes(frame.getHeader(name).getBytes());
            buffer.writeByte(10);
        }
        if (frame instanceof StompContentFrame) {
            int length = ((StompContentFrame)frame).getContent().readableBytes();
            buffer.writeBytes("content-length".getBytes());
            buffer.writeBytes(HEADER_DELIM);
            buffer.writeBytes(("" + length).getBytes());
            buffer.writeByte(10);
        }
        buffer.writeByte(10);
    }

    protected void writeContent(StompFrame frame, ChannelBuffer buffer) {
        if (frame instanceof StompContentFrame) {
            ChannelBuffer content = ((StompContentFrame)frame).getContent();
            buffer.writeBytes(content);
        }
        buffer.writeByte(0);
    }
}

