/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.websocket.ietf08;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.projectodd.stilts.stomp.protocol.websocket.Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.ietf07.Ietf07WebSocketChallenge;
import org.projectodd.stilts.stomp.protocol.websocket.ietf07.Ietf07WebSocketFrameDecoder;
import org.projectodd.stilts.stomp.protocol.websocket.ietf07.Ietf07WebSocketFrameEncoder;
import org.projectodd.stilts.stomp.protocol.websocket.ietf07.PingHandler;

public class Ietf08Handshake
extends Handshake {
    private static Logger log = Logger.getLogger(Ietf08Handshake.class);
    private boolean isClient;
    private Ietf07WebSocketChallenge challenge = new Ietf07WebSocketChallenge();

    public Ietf08Handshake() throws NoSuchAlgorithmException {
        this(true);
    }

    public Ietf08Handshake(boolean isClient) throws NoSuchAlgorithmException {
        super("8");
        this.isClient = isClient;
    }

    @Override
    public boolean matches(HttpRequest request) {
        return request.containsHeader("Sec-WebSocket-Key") && this.getVersion().equals(request.getHeader("Sec-WebSocket-Version"));
    }

    @Override
    public HttpRequest generateRequest(URI uri) throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getPath());
        request.addHeader("Sec-WebSocket-Version", (Object)"7");
        request.addHeader("Connection", (Object)"Upgrade");
        request.addHeader("Upgrade", (Object)"WebSocket");
        request.addHeader("Host", (Object)(uri.getHost() + ":" + uri.getPort()));
        request.addHeader("Sec-WebSocket-Protocol", (Object)"stomp");
        request.addHeader("Sec-WebSocket-Key", (Object)this.challenge.getNonceBase64());
        request.setContent(ChannelBuffers.EMPTY_BUFFER);
        return request;
    }

    @Override
    public HttpResponse generateResponse(HttpRequest request) throws Exception {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "Web Socket Protocol Handshake - IETF-07"));
        String origin = request.getHeader("Origin");
        if (origin != null) {
            response.addHeader("Sec-WebSocket-Origin", (Object)origin);
        }
        response.addHeader("Sec-WebSocket-Location", (Object)this.getWebSocketLocation(request));
        String protocol = request.getHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", (Object)protocol);
        }
        String key = request.getHeader("Sec-WebSocket-Key");
        String solution = Ietf07WebSocketChallenge.solve(key);
        response.addHeader("Sec-WebSocket-Accept", (Object)solution);
        response.setChunked(false);
        return response;
    }

    @Override
    public boolean isComplete(HttpResponse response) throws Exception {
        log.errorf("COMPLETE? " + response, new Object[0]);
        String challengeResponse = response.getHeader("Sec-WebSocket-Accept");
        return this.challenge.verify(challengeResponse);
    }

    @Override
    public ChannelHandler newEncoder() {
        return new Ietf07WebSocketFrameEncoder(this.isClient);
    }

    @Override
    public ChannelHandler newDecoder() {
        return new Ietf07WebSocketFrameDecoder();
    }

    @Override
    public ChannelHandler[] newAdditionalHandlers() {
        return new ChannelHandler[]{new PingHandler()};
    }

    @Override
    public int readResponseBody() {
        return 0;
    }
}

