/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectodd.stilts.stomp.DefaultHeaders;
import org.projectodd.stilts.stomp.DefaultStompMessageFactory;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.StompMessageFactory;
import org.projectodd.stilts.stomp.StompMessages;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;
import org.projectodd.stilts.stomp.protocol.StompMessageDecoder;

public class StompMessageDecoderTest {
    private DecoderEmbedder<StompMessage> decoder;

    @Before
    public void setUp() {
        this.decoder = new DecoderEmbedder(new ChannelUpstreamHandler[]{new StompMessageDecoder((StompMessageFactory)DefaultStompMessageFactory.INSTANCE)});
    }

    @Test
    public void testControlFrame() throws Exception {
        StompFrame frame = StompFrames.newAckFrame((Headers)new DefaultHeaders());
        boolean result = this.decoder.offer((Object)frame);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testContentFrame() throws Exception {
        StompMessage message = StompMessages.createStompMessage((String)"/queues/one", (String)"wtf is a taco?");
        StompFrame frame = StompFrames.newSendFrame((StompMessage)message);
        boolean result = this.decoder.offer((Object)frame);
        Assert.assertTrue((boolean)result);
        StompMessage outputMessage = (StompMessage)this.decoder.poll();
        Assert.assertNotNull((Object)outputMessage);
        Assert.assertNotSame((Object)message, (Object)outputMessage);
        Assert.assertEquals((Object)"/queues/one", (Object)outputMessage.getDestination());
        Assert.assertEquals((Object)"wtf is a taco?", (Object)outputMessage.getContentAsString());
    }
}

