/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.lang.reflect.Array;
import java.net.SocketAddress;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineException;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.embedder.CodecEmbedderException;
import org.projectodd.stilts.stomp.protocol.EmbeddedChannel;

public class HandlerEmbedder {
    private final Channel channel;
    private final ChannelPipeline pipeline;
    private final EmbeddedChannelSink sink = new EmbeddedChannelSink();
    final Queue<Object> productQueue = new LinkedList<Object>();

    public HandlerEmbedder(ChannelHandler ... handlers) {
        this(true, handlers);
    }

    public HandlerEmbedder(boolean fireInitialEvents, ChannelHandler ... handlers) {
        this.pipeline = new EmbeddedChannelPipeline();
        this.configurePipeline(handlers);
        this.channel = new EmbeddedChannel(this.pipeline, this.sink);
        if (fireInitialEvents) {
            this.fireInitialEvents();
        }
    }

    public HandlerEmbedder(ChannelBufferFactory bufferFactory, ChannelHandler ... handlers) {
        this(handlers);
        this.getChannel().getConfig().setBufferFactory(bufferFactory);
    }

    public void sendUpstream(Object message) {
        if (message instanceof ChannelEvent) {
            this.pipeline.sendUpstream((ChannelEvent)message);
        } else {
            Channels.fireMessageReceived((Channel)this.channel, (Object)message);
        }
    }

    public void sendDownstream(Object message) {
        if (message instanceof ChannelEvent) {
            this.pipeline.sendDownstream((ChannelEvent)message);
        } else {
            Channels.write((Channel)this.channel, (Object)message);
        }
    }

    private void fireInitialEvents() {
        Channels.fireChannelOpen((Channel)this.channel);
        Channels.fireChannelBound((Channel)this.channel, (SocketAddress)this.channel.getLocalAddress());
        Channels.fireChannelConnected((Channel)this.channel, (SocketAddress)this.channel.getRemoteAddress());
    }

    private void configurePipeline(ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers should contain at least one " + ChannelHandler.class.getSimpleName() + '.');
        }
        for (int i = 0; i < handlers.length; ++i) {
            ChannelHandler h = handlers[i];
            if (h == null) {
                throw new NullPointerException("handlers[" + i + "]");
            }
            this.pipeline.addLast(String.valueOf(i), handlers[i]);
        }
        this.pipeline.addLast("SINK", (ChannelHandler)this.sink);
    }

    public boolean finish() {
        Channels.fireChannelDisconnected((Channel)this.channel);
        Channels.fireChannelUnbound((Channel)this.channel);
        Channels.fireChannelClosed((Channel)this.channel);
        return !this.productQueue.isEmpty();
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public ChannelPipeline getPipeline() {
        return this.pipeline;
    }

    protected final boolean isEmpty() {
        return this.productQueue.isEmpty();
    }

    public final Object poll() {
        return this.productQueue.poll();
    }

    public final Object peek() {
        return this.productQueue.peek();
    }

    public final Object[] pollAll() {
        int size = this.size();
        Object[] a = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object product = this.poll();
            if (product == null) {
                throw new ConcurrentModificationException();
            }
            a[i] = product;
        }
        return a;
    }

    public final <T> T[] pollAll(T[] a) {
        Object product;
        if (a == null) {
            throw new NullPointerException("a");
        }
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while ((product = this.poll()) != null) {
            a[i] = product;
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public final int size() {
        return this.productQueue.size();
    }

    private static final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline() {
        }

        protected void notifyHandlerException(ChannelEvent e, Throwable t) {
            while (t instanceof ChannelPipelineException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof CodecEmbedderException) {
                throw (CodecEmbedderException)t;
            }
            throw new CodecEmbedderException(t);
        }
    }

    private final class EmbeddedChannelSink
    implements ChannelSink,
    ChannelUpstreamHandler {
        EmbeddedChannelSink() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) {
            this.handleEvent(e);
        }

        public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(ChannelEvent e) {
            if (e instanceof ExceptionEvent) {
                throw new CodecEmbedderException(((ExceptionEvent)e).getCause());
            }
            if (e instanceof MessageEvent) {
                boolean offered = HandlerEmbedder.this.productQueue.offer(((MessageEvent)e).getMessage());
                assert (offered);
            } else {
                boolean offered = HandlerEmbedder.this.productQueue.offer(e);
                assert (offered);
            }
        }

        public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent e, ChannelPipelineException cause) throws Exception {
            Throwable actualCause = cause.getCause();
            if (actualCause == null) {
                actualCause = cause;
            }
            throw new CodecEmbedderException(actualCause);
        }
    }
}

