/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectodd.stilts.stomp.protocol.StompContentFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrameDecoder;

public class StompFrameDecoderTest {
    private DecoderEmbedder<StompFrame> decoder;

    @Before
    public void setUp() {
        this.decoder = new DecoderEmbedder(new ChannelUpstreamHandler[]{new StompFrameDecoder()});
    }

    @Test
    public void testDecodeConnect() throws Exception {
        ChannelBuffer bytes = this.read("valid-connect.msg", true);
        this.decoder.offer((Object)bytes);
        StompFrame frame = (StompFrame)this.decoder.poll();
        Assert.assertNotNull((Object)frame);
    }

    @Test
    public void testDecodeIncomplete() throws Exception {
        ChannelBuffer bytes = this.read("incomplete-connect.msg", false);
        this.decoder.offer((Object)bytes);
        StompFrame frame = (StompFrame)this.decoder.poll();
        Assert.assertNull((Object)frame);
        this.decoder.offer((Object)ChannelBuffers.copiedBuffer((byte[])new byte[]{10, 0}));
        frame = (StompFrame)this.decoder.poll();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)StompFrame.Command.CONNECT, (Object)frame.getCommand());
    }

    @Test
    public void testDecodeNullTerminatedMessage() throws Exception {
        ChannelBuffer bytes = this.read("null-terminated.msg", true);
        this.decoder.offer((Object)bytes);
        StompFrame frame = (StompFrame)this.decoder.poll();
        Assert.assertNotNull((Object)frame);
        Assert.assertTrue((boolean)(frame instanceof StompContentFrame));
        Assert.assertEquals((Object)StompFrame.Command.SEND, (Object)frame.getCommand());
        Assert.assertEquals((Object)"This is my message.\n", (Object)((StompContentFrame)frame).getContent().toString(Charset.forName("UTF-8")));
    }

    ChannelBuffer read(String name, boolean appendNull) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(name);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        int c = -1;
        while ((c = stream.read()) >= 0) {
            buffer.writeByte(c);
        }
        if (appendNull) {
            buffer.writeByte(0);
        }
        return buffer;
    }
}

