/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.bundle;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.projectodd.stilts.conduit.spi.StompSessionManager;
import org.projectodd.stilts.conduit.stomp.SimpleStompSessionManager;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.container.SimpleStompletContainer;
import org.projectodd.stilts.stomplet.container.StompletContainer;
import org.projectodd.stilts.stomplet.server.StompletServer;

public class StompletServerActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(StompletServerActivator.class);
    private SimpleStompletContainer container;
    private StompletTracker tracker;
    private StompletServer server;

    public void start(BundleContext context) throws Exception {
        log.infof("start: %s", (Object)context);
        this.server = new StompletServer();
        ServiceReference sref = context.getServiceReference(TransactionManager.class.getName());
        if (sref != null) {
            TransactionManager transactionManager = (TransactionManager)context.getService(sref);
            log.infof("adding transaction manager: %s", (Object)transactionManager);
            this.server.setTransactionManager(transactionManager);
        }
        this.tracker = new StompletTracker(context);
        this.tracker.open();
        this.container = new SimpleStompletContainer();
        this.server.setDefaultSessionManager((StompSessionManager)new SimpleStompSessionManager());
        this.server.setDefaultContainer((StompletContainer)this.container);
        this.server.start();
    }

    public void stop(BundleContext context) throws Exception {
        log.infof("stop: %s", (Object)context);
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    private class StompletTracker
    extends ServiceTracker {
        StompletTracker(BundleContext context) {
            super(context, Stomplet.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Stomplet stomplet = (Stomplet)super.addingService(reference);
            log.infof("adding: %s", (Object)stomplet);
            try {
                HashMap<String, String> props = new HashMap<String, String>();
                for (String key : reference.getPropertyKeys()) {
                    Object value = reference.getProperty(key);
                    if (!(value instanceof String)) continue;
                    props.put(key, (String)value);
                }
                String destinationPattern = (String)props.get("destinationPattern");
                log.infof("adding: %s -> %s", (Object)destinationPattern, (Object)stomplet);
                StompletServerActivator.this.container.addStomplet(destinationPattern, stomplet, props);
            }
            catch (StompException ex) {
                log.errorf((Throwable)ex, "Cannot add stomplet: %s", (Object)stomplet);
            }
            return stomplet;
        }

        public void removedService(ServiceReference reference, Object service) {
            super.removedService(reference, service);
            Stomplet stomplet = (Stomplet)service;
            try {
                String destinationPattern = (String)reference.getProperty("destinationPattern");
                log.infof("removing: %s -> %s", (Object)destinationPattern, (Object)stomplet);
                StompletServerActivator.this.container.removeStomplet(destinationPattern);
            }
            catch (StompException ex) {
                log.errorf((Throwable)ex, "Cannot remove stomplet: %s", (Object)stomplet);
            }
        }
    }
}

