/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.factory.config;

import com.jayway.jsonpath.Filter;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import reactor.core.Observable;
import reactor.event.Event;
import reactor.event.selector.JsonPathSelector;
import reactor.event.selector.Selectors;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.spring.annotation.ReplyTo;
import reactor.spring.annotation.Selector;
import reactor.util.StringUtils;

public class ConsumerBeanAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    public static final String REACTOR_CONVERSION_SERVICE_BEAN_NAME = "reactorConversionService";
    public static final ReflectionUtils.MethodFilter CONSUMER_METHOD_FILTER = new ReflectionUtils.MethodFilter(){

        public boolean matches(Method method) {
            return null != AnnotationUtils.findAnnotation((Method)method, Selector.class);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerBeanAutoConfiguration.class);
    private ApplicationContext appCtx;
    private BeanResolver beanResolver;
    private ConversionService conversionService;
    private TemplateAwareExpressionParser expressionParser = new SpelExpressionParser();
    private boolean started = false;

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent ev) {
        ApplicationContext ctx = ev.getApplicationContext();
        if (ctx != this.appCtx) {
            return;
        }
        ConsumerBeanAutoConfiguration consumerBeanAutoConfiguration = this;
        synchronized (consumerBeanAutoConfiguration) {
            block10: {
                if (this.started) {
                    return;
                }
                if (null == this.beanResolver) {
                    this.beanResolver = new BeanFactoryResolver((BeanFactory)ctx);
                }
                if (null == this.conversionService) {
                    try {
                        this.conversionService = (ConversionService)ctx.getBean(REACTOR_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
                    }
                    catch (BeansException be) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug("reactorConversionService has not been found in the context. Skipping.");
                    }
                }
            }
            for (String beanName : ctx.getBeanDefinitionNames()) {
                Class type = ctx.getType(beanName);
                Set<Method> methods = ConsumerBeanAutoConfiguration.findHandlerMethods(type, CONSUMER_METHOD_FILTER);
                if (methods == null || methods.size() <= 0) continue;
                this.wireBean(ctx.getBean(beanName), methods);
            }
            this.started = true;
        }
    }

    public void wireBean(Object bean, Set<Method> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (Method method : methods) {
            Object consumer;
            Selector selectorAnno = (Selector)AnnotationUtils.findAnnotation((Method)method, Selector.class);
            ReplyTo replyToAnno = (ReplyTo)AnnotationUtils.findAnnotation((Method)method, ReplyTo.class);
            Observable reactor = this.fetchObservable(selectorAnno, bean);
            reactor.event.selector.Selector selector = this.fetchSelector(selectorAnno, bean, method);
            Object replyTo = replyToAnno != null ? this.parseReplyTo(replyToAnno, bean) : null;
            Invoker handler = new Invoker(method, bean, this.conversionService);
            Object object = consumer = null != replyToAnno ? new ReplyToServiceConsumer(reactor, replyTo, handler) : new ServiceConsumer(handler);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attaching Consumer to Reactor[" + reactor + "] using Selector[" + selector + "]");
            }
            if (null == selector) {
                reactor.on((Consumer)consumer);
                continue;
            }
            reactor.on(selector, (Consumer)consumer);
        }
    }

    private <T> T expression(String selector, Object bean) {
        if (selector == null) {
            return null;
        }
        StandardEvaluationContext evalCtx = new StandardEvaluationContext();
        evalCtx.setRootObject(bean);
        evalCtx.setBeanResolver(this.beanResolver);
        return (T)this.expressionParser.parseExpression(selector).getValue((EvaluationContext)evalCtx);
    }

    protected Observable fetchObservable(Selector selectorAnno, Object bean) {
        return (Observable)this.expression(selectorAnno.reactor(), bean);
    }

    protected Object parseSelector(Selector selector, Object bean, Method method) {
        if (!StringUtils.hasText((String)selector.value())) {
            return method.getName();
        }
        try {
            return this.expression(selector.value(), bean);
        }
        catch (Exception e) {
            return selector.value();
        }
    }

    protected Object parseReplyTo(ReplyTo selector, Object bean) {
        if (StringUtils.isEmpty((Object)selector.value())) {
            return null;
        }
        try {
            return this.expression(selector.value(), bean);
        }
        catch (EvaluationException ee) {
            return selector.value();
        }
    }

    protected reactor.event.selector.Selector fetchSelector(Selector selectorAnno, Object bean, Method method) {
        Object sel;
        block11: {
            sel = this.parseSelector(selectorAnno, bean, method);
            try {
                switch (selectorAnno.type()) {
                    case OBJECT: {
                        return Selectors.object((Object)sel);
                    }
                    case REGEX: {
                        return Selectors.regex((String)sel.toString());
                    }
                    case URI: {
                        return Selectors.uri((String)sel.toString());
                    }
                    case TYPE: {
                        try {
                            return Selectors.type(Class.forName(sel.toString()));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    }
                    case JSON_PATH: {
                        return JsonPathSelector.jsonPathSelector((String)sel.toString(), (Filter[])new Filter[0]);
                    }
                }
            }
            catch (EvaluationException e) {
                if (!LOG.isTraceEnabled()) break block11;
                LOG.trace("Creating ObjectSelector for '" + sel + "' due to " + e.getMessage(), (Throwable)e);
            }
        }
        return Selectors.object((Object)sel);
    }

    public static Set<Method> findHandlerMethods(Class<?> handlerType, final ReflectionUtils.MethodFilter handlerMethodFilter) {
        final LinkedHashSet<Method> handlerMethods = new LinkedHashSet<Method>();
        if (handlerType == null) {
            return handlerMethods;
        }
        LinkedHashSet handlerTypes = new LinkedHashSet();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(handlerType)) {
            handlerTypes.add(handlerType);
            specificHandlerType = handlerType;
        }
        handlerTypes.addAll(Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            final Class targetClass = specificHandlerType != null ? specificHandlerType : clazz;
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (handlerMethodFilter.matches(specificMethod) && (bridgedMethod == specificMethod || !handlerMethodFilter.matches(bridgedMethod))) {
                        handlerMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return handlerMethods;
    }

    protected static final class Invoker
    implements Function<Event, Object> {
        private final Method method;
        private final Object bean;
        private final Class<?>[] argTypes;
        private final ConversionService conversionService;

        Invoker(Method method, Object bean, ConversionService conversionService) {
            this.method = method;
            this.bean = bean;
            this.conversionService = conversionService;
            this.argTypes = method.getParameterTypes();
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getBean() {
            return this.bean;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Object apply(Event ev) {
            if (this.argTypes.length == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + ev);
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean);
            }
            if (this.argTypes.length > 1) {
                throw new IllegalStateException("Multiple parameters not yet supported.");
            }
            if (Event.class.isAssignableFrom(this.argTypes[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + ev);
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{ev});
            }
            if (null == ev.getData() || this.argTypes[0].isAssignableFrom(ev.getData().getClass())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + ev.getData());
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{ev.getData()});
            }
            if (!this.argTypes[0].isAssignableFrom(ev.getClass()) && this.conversionService.canConvert(ev.getClass(), this.argTypes[0])) {
                ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{this.conversionService.convert((Object)ev, this.argTypes[0])});
            }
            if (this.conversionService.canConvert(ev.getData().getClass(), this.argTypes[0])) {
                Object convertedObj = this.conversionService.convert(ev.getData(), this.argTypes[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + convertedObj);
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{convertedObj});
            }
            throw new IllegalArgumentException("Cannot invoke method " + this.method + " passing parameter " + ev.getData());
        }
    }

    protected static final class ServiceConsumer
    implements Consumer<Event> {
        private final Invoker handler;

        ServiceConsumer(Invoker handler) {
            this.handler = handler;
        }

        public Invoker getHandler() {
            return this.handler;
        }

        public void accept(Event ev) {
            this.handler.apply(ev);
        }
    }

    protected static final class ReplyToServiceConsumer
    implements Consumer<Event> {
        private final Observable reactor;
        private final Object replyToKey;
        private final Invoker handler;

        ReplyToServiceConsumer(Observable reactor, Object replyToKey, Invoker handler) {
            this.reactor = reactor;
            this.replyToKey = replyToKey;
            this.handler = handler;
        }

        public Observable getReactor() {
            return this.reactor;
        }

        public Object getReplyToKey() {
            return this.replyToKey;
        }

        public Invoker getHandler() {
            return this.handler;
        }

        public void accept(Event ev) {
            Object _replyToKey;
            Object result = this.handler.apply(ev);
            Object object = _replyToKey = this.replyToKey != null ? this.replyToKey : ev.getReplyTo();
            if (_replyToKey != null) {
                this.reactor.notify(_replyToKey, Event.wrap((Object)result));
            }
        }
    }
}

