/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.bloat;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.api.CallingConvention;
import com.db4o.instrumentation.api.FieldRef;
import com.db4o.instrumentation.api.MethodBuilder;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.ReferenceProvider;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.instrumentation.bloat.BloatMemberRef;
import com.db4o.instrumentation.bloat.BloatReferenceProvider;
import com.db4o.instrumentation.bloat.BloatTypeRef;
import com.db4o.instrumentation.util.LabelGenerator;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class BloatMethodBuilder
implements MethodBuilder {
    private final MethodEditor methodEditor;
    private final LabelGenerator _labelGen;
    private final BloatReferenceProvider _references;
    private final Map _conversions = new HashMap();

    BloatMethodBuilder(BloatReferenceProvider references, ClassEditor classEditor, String methodName, TypeRef returnType, TypeRef[] parameterTypes) {
        this._references = references;
        this.methodEditor = new MethodEditor(classEditor, 1, BloatTypeRef.bloatType(returnType), methodName, BloatTypeRef.bloatTypes(parameterTypes), new Type[0]);
        this._labelGen = new LabelGenerator();
        this.methodEditor.addLabel(this._labelGen.createLabel(true));
        this.setUpConversions();
    }

    public void invoke(MethodRef method, CallingConvention convention) {
        if (convention == CallingConvention.INTERFACE) {
            this.invokeInterface(method);
        } else if (convention == CallingConvention.STATIC) {
            this.invokeStatic(method);
        } else {
            this.invokeVirtual(method);
        }
    }

    private void invokeInterface(MethodRef method) {
        this.addInstruction(185, this.memberRef(method));
    }

    private void invokeVirtual(MethodRef methodRef) {
        this.addInstruction(182, this.memberRef(methodRef));
    }

    private void invokeStatic(MethodRef methodRef) {
        this.addInstruction(184, this.memberRef(methodRef));
    }

    public void ldc(Object value) {
        this.addInstruction(18, this.coerce(value));
    }

    public void loadArgument(int index) {
        this.addInstruction(25, new LocalVariable(index));
    }

    public void pop() {
        this.addInstruction(87);
    }

    private MemberRef memberRef(Object ref) {
        return ((BloatMemberRef)ref).member();
    }

    public void endMethod() {
        this.addLabel(false);
        this.addInstruction(177);
        this.addLabel(true);
        this.methodEditor.commit();
    }

    private void addLabel(boolean startsBlock) {
        this.methodEditor.addLabel(this._labelGen.createLabel(startsBlock));
    }

    public void addInstruction(int opcode) {
        this.methodEditor.addInstruction(opcode);
    }

    public void print(PrintStream out) {
        this.methodEditor.print(out);
    }

    public void loadArrayElement(TypeRef elementType) {
        this.addInstruction(this.arrayElementOpcode(elementType));
    }

    private int arrayElementOpcode(TypeRef elementType) {
        if (elementType == this.integerType()) {
            return 46;
        }
        if (elementType == this.longType()) {
            return 47;
        }
        if (elementType == this.floatType()) {
            return 48;
        }
        if (elementType == this.doubleType()) {
            return 49;
        }
        return 50;
    }

    private TypeRef doubleType() {
        return this.type(Double.TYPE);
    }

    private TypeRef floatType() {
        return this.type(Float.TYPE);
    }

    private TypeRef longType() {
        return this.type(Long.TYPE);
    }

    private TypeRef integerType() {
        return this.type(Integer.TYPE);
    }

    private TypeRef type(Class type) {
        return this._references.forType(type);
    }

    public void addInstruction(Instruction instruction) {
        this.methodEditor.addInstruction(instruction);
    }

    public void addInstruction(int opcode, Object operand) {
        this.methodEditor.addInstruction(opcode, operand);
    }

    public void add(TypeRef operandType) {
        this.addInstruction(this.addOpcode(operandType));
    }

    private int addOpcode(TypeRef operandType) {
        if (operandType == this.doubleType()) {
            return 99;
        }
        if (operandType == this.floatType()) {
            return 98;
        }
        if (operandType == this.longType()) {
            return 97;
        }
        return 96;
    }

    public void subtract(TypeRef operandType) {
        this.addInstruction(this.subOpcode(operandType));
    }

    private int subOpcode(TypeRef operandType) {
        if (operandType == this.doubleType()) {
            return 103;
        }
        if (operandType == this.floatType()) {
            return 102;
        }
        if (operandType == this.longType()) {
            return 101;
        }
        return 100;
    }

    public void multiply(TypeRef operandType) {
        this.addInstruction(this.multOpcode(operandType));
    }

    private int multOpcode(TypeRef operandType) {
        if (operandType == this.doubleType()) {
            return 107;
        }
        if (operandType == this.floatType()) {
            return 106;
        }
        if (operandType == this.longType()) {
            return 105;
        }
        return 104;
    }

    public void divide(TypeRef operandType) {
        this.addInstruction(this.divOpcode(operandType));
    }

    private int divOpcode(TypeRef operandType) {
        if (operandType == this.doubleType()) {
            return 111;
        }
        if (operandType == this.floatType()) {
            return 110;
        }
        if (operandType == this.longType()) {
            return 109;
        }
        return 108;
    }

    public void invoke(Method method) {
        MethodRef methodRef = this._references.forMethod(method);
        if (this.isStatic(method)) {
            this.invokeStatic(methodRef);
        } else {
            this.invokeVirtual(methodRef);
        }
    }

    private boolean isStatic(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public ReferenceProvider references() {
        return this._references;
    }

    public void loadField(FieldRef fieldRef) {
        this.addInstruction(180, this.memberRef(fieldRef));
    }

    public void loadStaticField(FieldRef fieldRef) {
        this.addInstruction(178, this.memberRef(fieldRef));
    }

    public void box(TypeRef boxedType) {
        Class[] convSpec = (Class[])this._conversions.get(boxedType);
        if (null == convSpec) {
            return;
        }
        Class wrapperType = convSpec[0];
        Class primitiveType = convSpec[1];
        LocalVariable local = this.methodEditor.newLocal(this.bloatType(primitiveType));
        this.addInstruction(this.storeOpcode(primitiveType), local);
        this.addInstruction(187, this.bloatType(wrapperType));
        this.addInstruction(89);
        this.addInstruction(this.loadOpcode(primitiveType), local);
        this.addInstruction(183, this.memberRef(this._references.forMethod(this.type(convSpec[0]), "<init>", new TypeRef[]{this.type(primitiveType)}, this.type(Void.TYPE))));
    }

    private int loadOpcode(Class type) {
        if (type == Long.TYPE) {
            return 22;
        }
        if (type == Float.TYPE) {
            return 23;
        }
        if (type == Double.TYPE) {
            return 24;
        }
        return 21;
    }

    private int storeOpcode(Class type) {
        if (type == Long.TYPE) {
            return 55;
        }
        if (type == Float.TYPE) {
            return 56;
        }
        if (type == Double.TYPE) {
            return 57;
        }
        return 54;
    }

    private Type bloatType(Class type) {
        return this._references.bloatType(type);
    }

    private void setUpConversions() {
        this.setUpConversion(new Class[]{Integer.class, Integer.TYPE});
        this.setUpConversion(new Class[]{Long.class, Long.TYPE});
        this.setUpConversion(new Class[]{Short.class, Short.TYPE});
        this.setUpConversion(new Class[]{Byte.class, Byte.TYPE});
        this.setUpConversion(new Class[]{Double.class, Double.TYPE});
        this.setUpConversion(new Class[]{Float.class, Float.TYPE});
        this.setUpConversion(new Class[]{Boolean.class, Boolean.TYPE});
    }

    private void setUpConversion(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this._conversions.put(this.type(classes[i]), classes);
        }
    }

    private Object coerce(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? new Integer(1) : new Integer(0);
        }
        if (value instanceof Character) {
            return new Integer(((Character)value).charValue());
        }
        if (value instanceof Byte || value instanceof Short) {
            return new Integer(((Number)value).intValue());
        }
        return value;
    }
}

