/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.core;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import com.db4o.instrumentation.bloat.BloatReferenceProvider;
import com.db4o.instrumentation.util.BloatUtil;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;

public class BloatLoaderContext {
    private EditorContext context;
    private final BloatReferenceProvider references;

    public BloatLoaderContext(ClassInfoLoader loader) {
        this((EditorContext)new CachingBloatContext(loader, new LinkedList(), false));
    }

    public BloatLoaderContext(EditorContext context) {
        this.context = context;
        this.references = new BloatReferenceProvider();
    }

    public BloatReferenceProvider references() {
        return this.references;
    }

    public FlowGraph flowGraph(String className, String methodName) throws ClassNotFoundException {
        return this.flowGraph(className, methodName, null);
    }

    public FlowGraph flowGraph(String className, String methodName, Type[] argTypes) throws ClassNotFoundException {
        ClassEditor classEdit = this.classEditor(className);
        return this.flowGraph(classEdit, methodName, argTypes);
    }

    public FlowGraph flowGraph(ClassEditor classEdit, String methodName, Type[] argTypes) throws ClassNotFoundException {
        MethodEditor method = this.method(classEdit, methodName, argTypes);
        return method == null ? null : new FlowGraph(method);
    }

    public MethodEditor method(ClassEditor classEdit, String methodName, Type[] argTypes) throws ClassNotFoundException {
        ClassEditor clazz = classEdit;
        while (clazz != null) {
            MethodInfo[] methods = clazz.methods();
            for (int methodIdx = 0; methodIdx < methods.length; ++methodIdx) {
                MethodEditor methodEdit = this.context.editMethod(methods[methodIdx]);
                if (!methodEdit.name().equals(methodName) || !this.signatureMatchesTypes(argTypes, methodEdit)) continue;
                return methodEdit;
            }
            clazz = this.classEditor(clazz.superclass());
        }
        return null;
    }

    public FieldEditor field(ClassEditor classEdit, String fieldName, Type fieldType) throws ClassNotFoundException {
        ClassEditor clazz = classEdit;
        while (clazz != null) {
            FieldInfo[] fields = clazz.fields();
            for (int fieldIdx = 0; fieldIdx < fields.length; ++fieldIdx) {
                FieldInfo fieldInfo = fields[fieldIdx];
                FieldEditor fieldEdit = this.context.editField(fieldInfo);
                if (!fieldEdit.name().equals(fieldName) || !fieldType.equals((Object)fieldEdit.type())) continue;
                return fieldEdit;
            }
            clazz = this.classEditor(clazz.superclass());
        }
        return null;
    }

    public ClassEditor classEditor(Type type) throws ClassNotFoundException {
        return type == null ? null : this.classEditor(BloatUtil.normalizeClassName(type));
    }

    private boolean signatureMatchesTypes(Type[] argTypes, MethodEditor methodEdit) {
        int sigOffset;
        if (argTypes == null) {
            return true;
        }
        Type[] sigTypes = methodEdit.paramTypes();
        int n = sigOffset = methodEdit.isStatic() || methodEdit.isConstructor() ? 0 : 1;
        if (argTypes.length != sigTypes.length - sigOffset) {
            return false;
        }
        for (int idx = 0; idx < argTypes.length; ++idx) {
            if (argTypes[idx].className().equals(sigTypes[idx + sigOffset].className())) continue;
            return false;
        }
        return true;
    }

    public ClassEditor classEditor(String className) throws ClassNotFoundException {
        return this.context.editClass(className);
    }

    public ClassEditor classEditor(int modifiers, String className, Type superClass, Type[] interfaces) {
        return this.context.newClass(modifiers, className, superClass, interfaces);
    }

    public Type superType(Type type) throws ClassNotFoundException {
        return this.context.editClass(type).superclass();
    }

    public void commit() {
        try {
            this.context.commit();
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
            throw exc;
        }
    }
}

