/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.core;

public class InstrumentationStatus {
    public static final InstrumentationStatus FAILED = new InstrumentationStatus(false, false, "FAILED");
    public static final InstrumentationStatus INSTRUMENTED = new InstrumentationStatus(true, true, "INSTRUMENTED");
    public static final InstrumentationStatus NOT_INSTRUMENTED = new InstrumentationStatus(true, false, "NOT INSTRUMENTED");
    private final boolean _canContinue;
    private final boolean _isInstrumented;
    private final String _name;

    private InstrumentationStatus(boolean canContinue, boolean isInstrumented, String name) {
        this._canContinue = canContinue;
        this._isInstrumented = isInstrumented;
        this._name = name;
    }

    public boolean canContinue() {
        return this._canContinue;
    }

    public boolean isInstrumented() {
        return this._isInstrumented;
    }

    public InstrumentationStatus aggregate(InstrumentationStatus status, boolean ignoreFailure) {
        if (!(ignoreFailure || this._canContinue && status._canContinue)) {
            return FAILED;
        }
        if (this._isInstrumented || status._isInstrumented) {
            return INSTRUMENTED;
        }
        return NOT_INSTRUMENTED;
    }

    public String toString() {
        return this._name;
    }
}

