/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.main;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.file.ClassSource;
import EDU.purdue.cs.bloat.file.DefaultClassSource;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.CompositeBloatClassEdit;
import com.db4o.instrumentation.core.InstrumentationStatus;
import com.db4o.instrumentation.file.DefaultFilePathRoot;
import com.db4o.instrumentation.file.FilePathRoot;
import com.db4o.instrumentation.file.InstrumentationClassSource;
import com.db4o.instrumentation.main.Db4oInstrumentationListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class Db4oFileInstrumentor {
    private final BloatClassEdit _classEdit;
    private final Set<Db4oInstrumentationListener> _listeners = new HashSet<Db4oInstrumentationListener>();

    public Db4oFileInstrumentor(BloatClassEdit classEdit) {
        this._classEdit = classEdit;
    }

    public Db4oFileInstrumentor(BloatClassEdit[] classEdits) {
        this(new CompositeBloatClassEdit(classEdits));
    }

    public void addInstrumentationListener(Db4oInstrumentationListener listener) {
        this._listeners.add(listener);
    }

    public void removeInstrumentationListener(Db4oInstrumentationListener listener) {
        this._listeners.remove(listener);
    }

    public void enhance(String sourceDir, String targetDir, String[] classpath) throws Exception {
        this.enhance(new DefaultFilePathRoot(new String[]{sourceDir}, ".class"), targetDir, classpath);
    }

    public void enhance(FilePathRoot sources, String targetDir, String[] classpath) throws Exception {
        this.enhance((ClassSource)new DefaultClassSource(), sources, targetDir, classpath);
    }

    public void enhance(ClassSource classSource, FilePathRoot sources, String targetDir, String[] classpath) throws Exception {
        this.enhance(classSource, sources, targetDir, classpath, ClassLoader.getSystemClassLoader());
    }

    public void enhance(ClassSource classSource, FilePathRoot sources, String targetDir, String[] classpath, ClassLoader parentClassLoader) throws Exception {
        File fTargetDir = new File(targetDir);
        ClassFileLoader fileLoader = new ClassFileLoader(classSource);
        String[] fullClasspath = this.fullClasspath(sources, classpath);
        this.setOutputDir(fileLoader, fTargetDir);
        this.setClasspath(fileLoader, fullClasspath);
        URL[] urls = this.classpathToURLs(fullClasspath);
        URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
        this.enhance(sources, fTargetDir, classLoader, new BloatLoaderContext((ClassInfoLoader)fileLoader));
        fileLoader.done();
    }

    private void enhance(FilePathRoot sources, File target, ClassLoader classLoader, BloatLoaderContext bloatUtil) throws Exception {
        for (Db4oInstrumentationListener listener : this._listeners) {
            listener.notifyStartProcessing(sources);
        }
        for (InstrumentationClassSource file : sources) {
            this.enhanceFile(file, target, classLoader, bloatUtil);
        }
        for (Db4oInstrumentationListener listener : this._listeners) {
            listener.notifyEndProcessing(sources);
        }
    }

    private void enhanceFile(InstrumentationClassSource source, File target, ClassLoader classLoader, BloatLoaderContext bloatUtil) throws IOException, ClassNotFoundException {
        ClassEditor classEditor = bloatUtil.classEditor(source.className());
        InstrumentationStatus status = this._classEdit.enhance(classEditor, classLoader, bloatUtil);
        this.notifyListeners(source, status);
        if (!status.isInstrumented()) {
            File targetFile = source.targetPath(target);
            targetFile.getParentFile().mkdirs();
            this.copy(source, targetFile);
        }
    }

    private void notifyListeners(InstrumentationClassSource source, InstrumentationStatus status) {
        for (Db4oInstrumentationListener listener : this._listeners) {
            listener.notifyProcessed(source, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InstrumentationClassSource source, File targetFile) throws IOException {
        if (targetFile.equals(source.sourceFile())) {
            return;
        }
        int bufSize = 4096;
        BufferedInputStream bufIn = new BufferedInputStream(source.inputStream(), 4096);
        try {
            BufferedOutputStream bufOut = new BufferedOutputStream(new FileOutputStream(targetFile));
            try {
                this.copy(4096, bufIn, bufOut);
            }
            finally {
                bufOut.close();
            }
        }
        finally {
            bufIn.close();
        }
    }

    private void copy(int bufSize, BufferedInputStream bufIn, BufferedOutputStream bufOut) throws IOException {
        byte[] buf = new byte[bufSize];
        int bytesRead = -1;
        while ((bytesRead = bufIn.read(buf)) >= 0) {
            bufOut.write(buf, 0, bytesRead);
        }
    }

    private String[] fullClasspath(FilePathRoot sources, String[] classpath) throws IOException {
        String[] sourceRoots = sources.rootDirs();
        String[] fullClasspath = new String[sourceRoots.length + classpath.length];
        System.arraycopy(sourceRoots, 0, fullClasspath, 0, sourceRoots.length);
        System.arraycopy(classpath, 0, fullClasspath, sourceRoots.length, classpath.length);
        return fullClasspath;
    }

    private void setOutputDir(ClassFileLoader fileLoader, File fTargetDir) {
        fileLoader.setOutputDir(fTargetDir);
    }

    private void setClasspath(ClassFileLoader fileLoader, String[] classPath) {
        for (int pathIdx = 0; pathIdx < classPath.length; ++pathIdx) {
            fileLoader.appendClassPath(classPath[pathIdx]);
        }
    }

    private URL[] classpathToURLs(String[] classPath) throws MalformedURLException {
        URL[] urls = new URL[classPath.length];
        for (int pathIdx = 0; pathIdx < classPath.length; ++pathIdx) {
            urls[pathIdx] = this.toURL(classPath[pathIdx]);
        }
        return urls;
    }

    private URL toURL(String classPathItem) throws MalformedURLException {
        return new File(classPathItem).toURL();
    }
}

